/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.capabilities;

import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DeviceObject;
import core.support.objects.TestObject;
import core.uiCore.AppiumServer;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AndroidCapability {
    public DesiredCapabilities capabilities;
    public static String APP_DIR_PATH = "android.appDir";
    public static String APP_NAME = "android.app";
    public static String CHROME_VERSION = "appium.chromeVersion";
    public static String iS_CHROME_AUTO_MANAGE = "appium.chromeAutoManage";
    public static String CHROME_DRIVER_PATH = "appium.chromeDriverPath";
    public static String ANDROID_ENGINE = "android.capabilties.automationName";
    public static String UIAUTOMATOR2 = "UiAutomator2";
    public static boolean ANDROID_INIT = false;
    public static String ANDROID_HOME = "android.home";
    private static final String CAPABILITIES_PREFIX = "android.capabilties.";
    public List<String> simulatorList = new ArrayList<String>();
    public static int SYSTEM_PORT = 8200;

    public AndroidCapability() {
        this.capabilities = new DesiredCapabilities();
    }

    public AndroidCapability withCapability(DesiredCapabilities Capabilities) {
        this.capabilities = Capabilities;
        return this;
    }

    public AndroidCapability withDevice(String device) {
        this.simulatorList = Config.getValueList(device);
        return this;
    }

    public String getChromeDriverVersion() {
        String value = Config.getValue(CHROME_VERSION);
        return value;
    }

    public boolean isChromeAutoManager() {
        boolean value = Config.getBooleanValue(iS_CHROME_AUTO_MANAGE);
        return value;
    }

    public String chromeDriverPath() {
        String value = Config.getValue(CHROME_DRIVER_PATH);
        return value;
    }

    public DesiredCapabilities getCapability() {
        return this.capabilities;
    }

    public String getAppPath() {
        String appRootPath = PropertiesReader.getLocalRootPath() + Config.getValue(APP_DIR_PATH);
        File appPath = new File(appRootPath, Config.getValue(APP_NAME));
        if (!appPath.exists()) {
            TestLog.ConsoleLogWarn("app not found at: " + appPath.getAbsolutePath(), new Object[0]);
        }
        return appPath.getAbsolutePath();
    }

    public AndroidCapability withAndroidCapability() {
        this.capabilities = this.setAndroidCapabilties();
        this.capabilities.setCapability("app", this.getAppPath());
        if (!this.getChromeDriverVersion().equals("DEFAULT")) {
            WebDriverManager.chromedriver().version(this.getChromeDriverVersion()).setup();
            String chromePath = WebDriverManager.chromedriver().getBinaryPath();
            this.capabilities.setCapability("chromedriverExecutable", chromePath);
        }
        AndroidCapability.setAndroidHome();
        this.setAndroidDevice();
        this.setPort(TestObject.getTestInfo().deviceName);
        this.setSingleSignIn();
        return this;
    }

    public DesiredCapabilities setAndroidCapabilties() {
        AndroidCapability.uninstallUiAutomator2();
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isAndroidCapability = entry.getKey().toString().startsWith(CAPABILITIES_PREFIX);
            if (!isAndroidCapability) continue;
            String fullKey = entry.getKey().toString();
            String key = fullKey.substring(fullKey.lastIndexOf(".") + 1).trim();
            String value = entry.getValue().toString().trim();
            this.capabilities.setCapability(key, value);
        }
        return this.capabilities;
    }

    public void setChromePath() {
        if (!this.getChromeDriverVersion().equals("DEFAULT")) {
            String chromePath;
            if (this.isChromeAutoManager()) {
                WebDriverManager.chromedriver().version(this.getChromeDriverVersion()).setup();
                chromePath = WebDriverManager.chromedriver().getBinaryPath();
            } else {
                chromePath = PropertiesReader.getLocalRootPath() + this.chromeDriverPath();
            }
            this.capabilities.setCapability("chromedriverExecutable", chromePath);
        }
    }

    public void setSingleSignIn() {
        if (CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            if (AbstractDriver.isFirstRun().booleanValue()) {
                this.capabilities.setCapability("noReset", false);
            } else {
                this.capabilities.setCapability("noReset", true);
            }
        }
    }

    public boolean isRealDeviceConnected() {
        List<String> devices = this.getAndroidDeviceList();
        for (String device : devices) {
            if (device.contains("emulator")) continue;
            return true;
        }
        return false;
    }

    public static List<String> getRealDevices(List<String> devices) {
        ArrayList<String> realDeviceList = new ArrayList<String>();
        for (String device : devices) {
            if (device.contains("emulator")) continue;
            realDeviceList.add(device);
        }
        return realDeviceList;
    }

    public List<String> getAndroidDeviceList() {
        String cmd = !Config.getValue(AppiumServer.ANDROID_HOME).isEmpty() ? Config.getValue(AppiumServer.ANDROID_HOME) + "/platform-tools/adb devices" : "adb devices";
        List<Object> results = new ArrayList();
        results = Config.getValueList("android.UDID");
        if (results.size() == 0 && !(results = Helper.runShellCommand(cmd)).isEmpty()) {
            results.remove(0);
        }
        ArrayList<String> devices = new ArrayList<String>();
        for (String string : results) {
            String[] arr = string.split("\t", 2);
            String device = arr[0];
            if (device.isEmpty()) continue;
            devices.add(device);
        }
        if (results.size() > 0) {
            TestLog.ConsoleLogDebug("Android device list: " + Arrays.toString(results.toArray()), new Object[0]);
        }
        return devices;
    }

    public List<String> getAndroidRealDeviceList() {
        List<String> devices = this.getAndroidDeviceList();
        return AndroidCapability.getRealDevices(devices);
    }

    public void setSimulator() {
        int threads;
        List<String> devices = this.simulatorList;
        if (devices == null || devices.isEmpty()) {
            Helper.assertFalse("set device first");
        }
        if ((threads = CrossPlatformProperties.getParallelTests()) > devices.size()) {
            Helper.assertFalse("there are more threads than devices. global.parallelTestCount: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.Android);
        this.capabilities.setCapability("avd", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.Android));
    }

    public synchronized void setPort(String deviceName) {
        if (DeviceManager.devices.get(deviceName) != null && DeviceManager.devices.get((Object)deviceName).devicePort != -1) {
            this.capabilities.setCapability("systemPort", (Object)DeviceManager.devices.get((Object)deviceName).devicePort);
        } else {
            int systemPort = ++SYSTEM_PORT;
            this.capabilities.setCapability("systemPort", (Object)systemPort);
            DeviceManager.devices.get(deviceName).withDevicePort(systemPort);
        }
        TestLog.ConsoleLog("deviceName " + deviceName + " systemPort: " + DeviceManager.devices.get((Object)deviceName).devicePort, new Object[0]);
    }

    public static void restartAdb() {
        Helper.runShellCommand("adb kill-server");
        Helper.runShellCommand("adb start-server");
    }

    public static void uninstallUiAutomator2() {
        if (!ANDROID_INIT) {
            ANDROID_INIT = true;
            if (Config.getValue(ANDROID_ENGINE).equals(UIAUTOMATOR2)) {
                TestLog.ConsoleLog("Uninstalling uiautomator2.server", new Object[0]);
                TestLog.ConsoleLog("Uninstalling uiautomator2.server.test", new Object[0]);
                Helper.runShellCommand("adb uninstall io.appium.uiautomator2.server");
                Helper.runShellCommand("adb uninstall io.appium.uiautomator2.server.test");
            }
        }
    }

    public void setRealDevices() {
        List<String> devices = this.getAndroidRealDeviceList();
        int threads = CrossPlatformProperties.getParallelTests();
        if (threads > devices.size()) {
            Helper.assertFalse("there are more threads than devices. thread count: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.Android);
        this.capabilities.setCapability("udid", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.Android));
    }

    public void setAndroidDevice() {
        if (!PropertiesReader.isUsingCloud()) {
            if (this.isRealDeviceConnected()) {
                this.setRealDevices();
            } else {
                this.setSimulator();
            }
        }
    }

    public static void printAndroidHelp(Exception e) {
        String androidError = "It is impossible to create a new session";
        String androidSolution = "*******************************************************************\r\n\r\n\r\n\r\n*******************************************************************\r\n\r\n1. this could be an environment issue. Try the following solutions:\r\n    1. Turn on debugging in properties at resource folder for more info:\r\n        1. appiumLogging = true\r\n    2. set android home environment in properties\r\n        1. androidHome = \"/Users/username/Library/Android/sdk\"\r\n    3. please download appium doctor https://github.com/appium/appium-doctor\r\n        1. download with command: npm install appium-doctor -g\r\n        2. Run: appium-doctor -android\r\n        3. Ensure the environment is setup properly\r\n        4. Restart eclipse\r\n    4. is appium terminal installation correct?\r\n        1. command line: appium\r\n            1. Does it start. If not install: \u201cnpm install -g appium\u201d  or \u201csudo npm install -g appium --unsafe-perm=true --allow-root\u201d\r\n            2. Run against appium terminal\r\n                1. In properties set:\r\n                    1. useExternalAppiumServer = true\r\n                    2. appiumExternalPort = 4723\r\n                2. run test And see if it passes\r\n    5. is simulator working correctly: Run\r\n        1. adb uninstall io.appium.uiautomator2.server\r\n        2. adb uninstall io.appium.uiautomator2.server.test \r\n    6. Try running against appium desktop server\r\n        1. Download And run appium desktop\r\n        2. Start the server\r\n        3. In properties at resource folder, set values\r\n            1. useExternalAppiumServer = true\r\n            2. appiumExternalPort = 4723\r\n            3. run test\r\n*******************************************************************\r\n\r\n\r\n\r\n*******************************************************************";
        if (e.getMessage().contains(androidError)) {
            System.out.println(androidSolution);
        }
    }

    public static void setAndroidHome() {
        String userHome = System.getProperty("user.home");
        String androidHome = Config.getValue(ANDROID_HOME);
        String javaHomePath = "";
        if (androidHome.isEmpty()) {
            boolean isAndroidHome;
            if (Helper.isMac()) {
                javaHomePath = userHome + File.separator + "Library" + File.separator + "Android" + File.separator + "sdk/";
            }
            if (isAndroidHome = new File(javaHomePath).exists()) {
                Config.putValue(ANDROID_HOME, javaHomePath);
            }
        }
    }
}

