/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore;

import com.microsoft.appcenter.appium.EnhancedAndroidDriver;
import com.microsoft.appcenter.appium.Factory;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.uiCore.AppiumServer;
import core.uiCore.driverProperties.browserType;
import core.uiCore.driverProperties.driverType;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.windows.WindowsDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverSetup {
    public static String SERVER_URL = "web.remote.server_url";
    public static String SERVER_PORT = "web.remote.server_port";
    public static String LATEST_BROWSER_VERSION = "LATEST";

    public WebDriver getWebDriverByType(DriverObject driverObject) throws IOException {
        WebDriver driver = null;
        driverType.DriverType type = driverObject.driverType;
        switch (type) {
            case LOCAL_WEBDRIVER: {
                driver = this.getBrowserDriverByType(driverObject);
                break;
            }
            case REMOTE_WEBDRIVER: {
                driver = new RemoteWebDriver(new URL(this.getServerUrl() + ":" + this.getServerPort() + "/wd/hub"), (Capabilities)driverObject.capabilities);
                break;
            }
            case IOS_DRIVER: {
                if (Config.getBooleanValue("appium.useExternalAppiumServer").booleanValue()) {
                    int port = Config.getIntValue("appium.externalPort");
                    TestLog.ConsoleLog("Connecting to external appium server at port " + port, new Object[0]);
                    driver = new IOSDriver(new URL("http://localhost:" + port + "/wd/hub"), (Capabilities)driverObject.capabilities);
                    break;
                }
                TestLog.ConsoleLog("Connecting to internal appium server", new Object[0]);
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new IOSDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            case ANDROID_DRIVER: {
                if (Config.getBooleanValue("appium.useExternalAppiumServer").booleanValue()) {
                    int port = Config.getIntValue("appium.externalPort");
                    driver = new AndroidDriver(new URL("http://localhost:" + port + "/wd/hub"), (Capabilities)driverObject.capabilities);
                    break;
                }
                if (PropertiesReader.isUsingCloud()) {
                    EnhancedAndroidDriver appcenterDriver = Factory.createAndroidDriver((URL)new URL("http://localhost:8001/wd/hub"), (DesiredCapabilities)driverObject.capabilities);
                    return appcenterDriver;
                }
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new AndroidDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            case WINAPP_DRIVER: {
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new WindowsDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported driverype " + (Object)((Object)type));
            }
        }
        return driver;
    }

    public WebDriver getBrowserDriverByType(DriverObject driverObject) throws IOException {
        FirefoxDriver driver = null;
        browserType.BrowserType browserType2 = driverObject.browserType;
        if (driverObject.driverVersion != null && driverObject.driverVersion.equals(LATEST_BROWSER_VERSION)) {
            driverObject.driverVersion = null;
        }
        switch (browserType2) {
            case FIREFOX: {
                WebDriverManager.firefoxdriver().version(driverObject.driverVersion).setup();
                driver = new FirefoxDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case FIREFOX_HEADLESS: {
                WebDriverManager.firefoxdriver().version(driverObject.driverVersion).setup();
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                firefoxOptions.setHeadless(true);
                driverObject.capabilities.setCapability("moz:firefoxOptions", (Object)firefoxOptions);
                driver = new FirefoxDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case INTERNET_EXPLORER: {
                WebDriverManager.iedriver().version(driverObject.driverVersion).setup();
                driver = new InternetExplorerDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case MICROSOFT_EDGE: {
                WebDriverManager.edgedriver().version(driverObject.driverVersion).setup();
                driver = new EdgeDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case CHROME: {
                WebDriverManager.chromedriver().version(driverObject.driverVersion).setup();
                driver = new ChromeDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case CHROME_HEADLESS: {
                WebDriverManager.chromedriver().version(driverObject.driverVersion).setup();
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setHeadless(true);
                driverObject.capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
                driver = new ChromeDriver((Capabilities)driverObject.capabilities);
                break;
            }
            case OPERA: {
                WebDriverManager.operadriver().version(driverObject.driverVersion).setup();
                driver = new OperaDriver((Capabilities)driverObject.capabilities);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported browsertype " + (Object)((Object)browserType2));
            }
        }
        return driver;
    }

    public String getServerUrl() {
        return "http://" + Config.getValue(SERVER_URL);
    }

    public String getServerPort() {
        return Config.getValue(SERVER_PORT);
    }
}

