/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore;

import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.GeneralServerFlag;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AppiumServer {
    public static String ANDROID_HOME = "android.home";
    public static String JAVA_HOME = "android.javaHome";
    public static String APPIUM_LOGGING = "appium.logging";
    public static String APPIUM_LOGGING_LEVEL = "appium.logginLevel";
    public static AppiumDriverLocalService service = null;

    public static AppiumDriverLocalService startAppiumServer(DriverObject driverObject) throws MalformedURLException {
        if (service != null && service.isRunning()) {
            return service;
        }
        Map<String, String> env = AppiumServer.setEnvVariables();
        AppiumServiceBuilder builder = new AppiumServiceBuilder().usingAnyFreePort().withEnvironment(env).withIPAddress("127.0.0.1").withArgument((ServerArgument)GeneralServerFlag.SESSION_OVERRIDE);
        if (Config.getBooleanValue(APPIUM_LOGGING).booleanValue()) {
            builder.withArgument((ServerArgument)GeneralServerFlag.LOG_LEVEL, Config.getValue(APPIUM_LOGGING_LEVEL));
        } else {
            builder.withArgument((ServerArgument)GeneralServerFlag.LOG_LEVEL, "error");
        }
        try {
            service = AppiumDriverLocalService.buildService((AppiumServiceBuilder)builder);
            service.start();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (service == null || !service.isRunning()) {
            throw new AppiumServerHasNotBeenStartedLocallyException("An appium server node is not started!");
        }
        AppiumServer.disableAppiumConsoleLogging(service);
        TestLog.And("Appium server has been initiated successfully", new Object[0]);
        return service;
    }

    public static Map<String, String> setEnvVariables() {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (!Config.getValue(ANDROID_HOME).isEmpty()) {
            env.put("ANDROID_HOME", Config.getValue(ANDROID_HOME));
        }
        if (!Config.getValue(JAVA_HOME).isEmpty()) {
            env.put("JAVA_HOME", Config.getValue(JAVA_HOME));
        }
        if (!CrossPlatformProperties.getPath().isEmpty()) {
            env.put("PATH", CrossPlatformProperties.getPath());
        }
        return env;
    }

    public static void disableAppiumConsoleLogging(AppiumDriverLocalService service) {
        if (Config.getValue(APPIUM_LOGGING).equals("true")) {
            return;
        }
        Field streamField = null;
        Field streamsField = null;
        try {
            streamField = AppiumDriverLocalService.class.getDeclaredField("stream");
            streamField.setAccessible(true);
            streamsField = Class.forName("io.appium.java_client.service.local.ListOutputStream").getDeclaredField("streams");
            streamsField.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        try {
            ((ArrayList)streamsField.get(streamField.get(service))).clear();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

