/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.manager;

import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class PanelManagerGenerator {
    public static void writePanelManagerClass(Map<String, List<Element>> panelMap) {
        try {
            PanelManagerGenerator.writePanelManagerClassImplementation(panelMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writePanelManagerClassImplementation(Map<String, List<Element>> panelMap) throws IOException {
        Logger.debug("<<<<start generating panel manager class>>>>");
        Logger.debug("writePanelManagerClass: panelManagers: " + panelMap.size());
        for (Map.Entry<String, List<Element>> entry : panelMap.entrySet()) {
            Element firstElement = entry.getValue().get(0);
            Logger.debug("panel name: " + entry.getKey());
            Logger.debug("panel value: " + entry.getValue().get(0).asType().toString());
            JavaFileObject fileObject = FileCreatorHelper.createFile(firstElement);
            BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
            Date currentDate = new Date();
            bw.append("/**Auto generated code,don't modify it.\n");
            bw.append("* Author             ---- > Auto Generated.\n");
            bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
            bw.append("*");
            bw.append("**/\n\n\n\n");
            bw.append("package " + PackageHelper.getPackagePath(firstElement) + ";\n");
            bw.newLine();
            bw.newLine();
            for (Element element : entry.getValue()) {
                String panelPath = element.asType().toString();
                bw.append("import " + panelPath + ";\n");
            }
            bw.append("import core.support.configReader.Config;\n");
            bw.append("import core.support.objects.DriverObject;\n");
            bw.newLine();
            bw.newLine();
            bw.append("public class PanelManager {\n\n\n");
            for (Element element : entry.getValue()) {
                String panelName = element.getSimpleName().toString();
                bw.append("public " + panelName + " " + panelName.replace("Panel", "").toLowerCase() + " = new " + panelName + "(this);\n");
            }
            bw.newLine();
            PanelManagerGenerator.writeDrivers(PackageHelper.getModuleName(firstElement), bw);
            bw.append("}\n");
            bw.flush();
            bw.close();
            Logger.debug("completed writing panel manager: " + entry.getKey());
        }
        Logger.debug("<<<<complete generating panel manager class>>>>>");
    }

    private static void writeDrivers(String moduleName, BufferedWriter bw) throws IOException {
        bw.append("public DriverObject getWebDriver() {\n");
        bw.append("\treturn new DriverObject().withWebDriver(\"" + moduleName + "\", Config.getValue(\"" + moduleName + "\"));\n");
        bw.append("}\n");
        bw.append("public DriverObject getWebDriver(String url) {\n");
        bw.append("\treturn new DriverObject().withWebDriver(\"" + moduleName + "\", Config.getValue(url));\n");
        bw.append("}\n");
        bw.append("public DriverObject getIosTabletDriver() {\n");
        bw.append("\treturn new DriverObject().withiOSDriver(\"" + moduleName + "\",\"ios.tablet\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getIosMobileDriver() {\n");
        bw.append("\treturn new DriverObject().withiOSDriver(\"" + moduleName + "\",\"ios.mobile\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getAndroidTabletDriver() {\n");
        bw.append("\treturn new DriverObject().withAndroidDriver(\"" + moduleName + "\",\"android.tablet\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getAndroidMobileDriver() {\n");
        bw.append("\treturn new DriverObject().withAndroidDriver(\"" + moduleName + "\",\"android.mobile\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getWinAppDriver() {\n");
        bw.append("\treturn new DriverObject().withWinDriver(\"" + moduleName + "\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getApiDriver() {\n");
        bw.append("\treturn new DriverObject().withApiDriver(\"" + moduleName + "\");\n");
        bw.append("}\n");
        bw.append("public DriverObject getGenericDriver() {\n");
        bw.append("\treturn new DriverObject().withGenericDriver(\"" + moduleName + "\");\n");
        bw.append("}\n");
    }
}

