/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.dataObject;

import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.annotation.helper.DataObjectHelper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class CsvDataObject {
    public static JavaFileObject CSV_File_Object = null;
    public static String MODULE_ROOT = "module";
    public static String DATA_ROOT = "data";
    public static String ID_COLUMN = "@id";

    public static void writeCsvDataClass() {
        try {
            CsvDataObject.writeCsvDataClassImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeCsvDataClassImplementation() throws Exception {
        Logger.debug("<<<< start generating data object classes >>>>");
        List<File> files = DataObjectHelper.getAllCsvDataFiles();
        Logger.debug("csv data class count:  " + files.size());
        if (files.isEmpty()) {
            return;
        }
        CsvDataObject.writeCsvObjectClasses(files);
        Logger.debug("<<<< completed generating data object classes >>>>");
    }

    private static void writeCsvObjectClasses(List<File> files) throws Exception {
        for (File file : files) {
            Logger.debug("writing csv data object:  " + file.getName());
            CsvDataObject.writeCsvObjectClass(file);
        }
    }

    private static void writeCsvObjectClass(File file) throws Exception {
        int rowIndex;
        String column;
        int i;
        String module = PackageHelper.getModuleFromFullPath(file);
        String csvName = file.getName().replaceFirst("[.][^.]+$", "");
        String filePath = PackageHelper.DATA_PATH + "." + module + "." + csvName;
        JavaFileObject fileObject = FileCreatorHelper.createFileAbsolutePath(filePath);
        List<String[]> csvDataWithHeader = Helper.csv_getAllCsvData(file.getAbsolutePath());
        boolean hasIdColumn = CsvDataObject.hasIdColumn(csvDataWithHeader);
        List<String[]> csvDataOnly = Helper.csv_getAllCsvDataFirstRowAsHeader(file.getAbsolutePath());
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + DATA_ROOT + "." + module + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("import org.apache.commons.lang3.StringUtils;\n");
        bw.append("import org.testng.annotations.DataProvider;\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class " + csvName + " {\n");
        bw.newLine();
        bw.newLine();
        int firstIndex = 0;
        if (hasIdColumn) {
            firstIndex = 1;
        }
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i];
            bw.append("private String " + column + " = StringUtils.EMPTY;\n");
        }
        bw.newLine();
        bw.newLine();
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i];
            bw.append("public " + csvName + " with" + StringUtils.capitalize((String)column) + "(String " + column + ") {\n");
            bw.append("    this." + column + " = " + column + ";\n");
            bw.append("    return this;\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i];
            bw.append("public String get" + StringUtils.capitalize((String)column) + "() {\n");
            bw.append("    return " + column + ";\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        for (rowIndex = 1; rowIndex < csvDataWithHeader.size(); ++rowIndex) {
            String key = CsvDataObject.updateForDuplicateIds(csvDataWithHeader).get(rowIndex - 1);
            bw.append("public " + csvName + " " + key + "() {\n");
            bw.append("    " + csvName + " " + csvName.toLowerCase() + " = new " + csvName + "()\n");
            for (int columnIndex = firstIndex; columnIndex < csvDataWithHeader.get(0).length; ++columnIndex) {
                String column2 = StringUtils.capitalize((String)csvDataWithHeader.get(0)[columnIndex]);
                String value = csvDataWithHeader.get(rowIndex)[columnIndex];
                value = DataHelper.replaceParameters(value);
                bw.append("             .with" + column2 + "(\"" + value + "\")");
                if (columnIndex == csvDataWithHeader.get(0).length - 1) {
                    bw.append(";");
                }
                bw.append("\n");
            }
            bw.append("    return " + csvName.toLowerCase() + ";\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        bw.append("@DataProvider(name = \"DataRunner\")\n");
        bw.append("public synchronized Object[][] dataProvider() {\n");
        bw.append("    return new Object[][] {\t\n");
        for (rowIndex = 0; rowIndex < csvDataOnly.size(); ++rowIndex) {
            List<Object> rowList = Arrays.asList((Object[])csvDataOnly.get(rowIndex));
            String step1 = StringUtils.join(rowList, (String)"\", \"");
            String rowString = StringUtils.wrap((String)step1, (String)"\"");
            if (hasIdColumn) {
                rowString = CsvDataObject.removeFirstColumn(rowString);
            }
            rowString = DataHelper.replaceParameters(rowString);
            bw.append(" \t{ " + rowString + " }");
            if (rowIndex < csvDataOnly.size() - 1) {
                bw.append(",\n");
                continue;
            }
            bw.append("\n");
        }
        bw.append("   };\n");
        bw.append("}\n");
        bw.newLine();
        bw.newLine();
        bw.append("}\n");
        bw.flush();
        bw.close();
    }

    private static List<String> updateForDuplicateIds(List<String[]> csvDataWithHeader) {
        ArrayList<String> idList = new ArrayList<String>();
        int index = 1;
        for (int rowIndex = 1; rowIndex < csvDataWithHeader.size(); ++rowIndex) {
            idList.add(csvDataWithHeader.get(rowIndex)[0]);
        }
        for (int i = 0; i < idList.size(); ++i) {
            if (Collections.frequency(idList, idList.get(i)) <= 1) continue;
            String updatedVal = (String)idList.get(i) + "_duplidateReplaceWithUniqueID_" + index++;
            idList.set(i, updatedVal);
        }
        return idList;
    }

    private static String removeFirstColumn(String row) {
        return row.substring(row.indexOf(",") + 1, row.length());
    }

    private static boolean hasIdColumn(List<String[]> csvDataWithHeader) {
        boolean hasIdColumn = false;
        String idColumn = csvDataWithHeader.get(0)[0];
        if (idColumn.equals(ID_COLUMN)) {
            hasIdColumn = true;
        }
        return hasIdColumn;
    }
}

