/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.annotationMap;

import core.support.annotation.Panel;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class PanelMapHelper {
    public static Map<String, List<Element>> getPanelMap(RoundEnvironment roundEnv) {
        return PanelMapHelper.addElementsToPanelMap(roundEnv);
    }

    public static Map<String, List<Element>> addElementsToPanelMap(RoundEnvironment roundEnv) {
        Map<String, List<Element>> panelMap = PanelMapHelper.initializePanelMap(roundEnv);
        String moduleName = "";
        for (Map.Entry<String, List<Element>> entry : panelMap.entrySet()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            moduleName = entry.getKey();
            for (Element element : roundEnv.getElementsAnnotatedWith(Panel.class)) {
                String currentModuleName;
                if (element.getKind() != ElementKind.CLASS || !(currentModuleName = PackageHelper.getModuleName(element)).equals(entry.getKey())) continue;
                Logger.debug("addElementsToPanelMap: module: " + currentModuleName + " adding panel: " + element.asType().toString());
                elements.add(element);
            }
            Logger.debug("addElementsToPanelMap: moduleName: " + moduleName + " panel count: " + elements.size());
            panelMap.put(moduleName, elements);
        }
        return panelMap;
    }

    public static Map<String, List<Element>> initializePanelMap(RoundEnvironment roundEnv) {
        HashMap<String, List<Element>> map = new HashMap<String, List<Element>>();
        ArrayList elements = new ArrayList();
        for (Element element : roundEnv.getElementsAnnotatedWith(Panel.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            String moduleName = PackageHelper.getModuleName(element);
            map.put(moduleName, elements);
        }
        return map;
    }
}

