/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Uninterruptibles;
import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class WaitHelper {
    public static final double WAIT_SHORT_SECONDS = 0.6;
    public static final double WAIT_MED_SECONDS = 1.5;
    public static final double WAIT_LONG_SECONDS = 3.0;
    public static final double WAIT_ZOOM_SECONDS = 0.2;
    public static final double WAIT_PAN_SECONDS = 0.3;

    public void waitForElementToLoad(EnhancedBy target) {
        this.waitForElementToLoad(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToLoad(EnhancedBy target, int time) {
        return this.waitForElementToLoad(target, time, 1);
    }

    public boolean waitForElementToLoad(final EnhancedBy target, int time, final int count) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return Element.findElements(target).count() >= count;
                }
            });
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS) {
                AssertHelper.assertTrue("element: " + target.name + " did not display in allowed time (s) " + time, false);
            }
            e.getMessage();
            return false;
        }
        return true;
    }

    public boolean mobile_waitAndRefreshForElementToLoad(final EnhancedBy target) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(AbstractDriver.TIMEOUT_SECONDS)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    Helper.mobile.refreshMobileApp();
                    boolean isFound = Element.findElements(target).count() >= 1;
                    return isFound;
                }
            });
        }
        catch (Exception e) {
            AssertHelper.assertTrue("element: " + target.name + " did not display in allowed time (s) " + AbstractDriver.TIMEOUT_SECONDS, false);
            e.getMessage();
            return false;
        }
        return true;
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2) {
        return this.waitForFirstElementToLoad(element1, element2, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(final EnhancedBy element1, final EnhancedBy element2, int time) {
        Helper.assertTrue("driver is null", AbstractDriver.getWebDriver() != null);
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    boolean isElement1Found = Element.findElements(element1).count() >= 1;
                    boolean isElement2Found = Element.findElements(element2).count() >= 1;
                    return isElement1Found || isElement2Found;
                }
            });
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS) {
                AssertHelper.assertTrue("element1: " + element1.name + " or element2: " + element2.name + " did not display in allowed time (s) " + time, false);
            }
            e.getMessage();
            return false;
        }
        return true;
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2, EnhancedBy element3) {
        return this.waitForFirstElementToLoad(element1, element2, element3, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(final EnhancedBy element1, final EnhancedBy element2, final EnhancedBy element3, int time) {
        Helper.assertTrue("driver is null", AbstractDriver.getWebDriver() != null);
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(AbstractDriver.TIMEOUT_SECONDS)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    boolean isElement1Found = Element.findElements(element1).count() >= 1;
                    boolean isElement2Found = Element.findElements(element2).count() >= 1;
                    boolean isElement3Found = Element.findElements(element3).count() >= 1;
                    return isElement1Found || isElement2Found || isElement3Found;
                }
            });
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS) {
                AssertHelper.assertTrue("element1: " + element1.name + " or element2: " + element2.name + " did not display in allowed time (s) " + time, false);
            }
            e.getMessage();
            return false;
        }
        return true;
    }

    public void waitForAdditionalElementsToLoad(final EnhancedBy target, final int originalCount) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(AbstractDriver.TIMEOUT_SECONDS)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                AssertHelper.assertTrue("element: " + target.name + " did not display in allowed time (s) " + AbstractDriver.TIMEOUT_SECONDS, false);
                return Helper.list.getListCount(target) > originalCount;
            }
        });
    }

    public void waitForElementToBeRemoved(EnhancedBy target) {
        this.waitForElementToBeRemoved(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeRemoved(final EnhancedBy target, int time) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    EnhancedWebElement elements = Element.findElements(target);
                    try {
                        int x = 0;
                        while (x < elements.count()) {
                            if (!elements.isExist(x++)) continue;
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.getMessage();
            return false;
        }
        return true;
    }

    public void waitForSeconds(double seconds) {
        long miliseconds = (long)(seconds * 1000.0);
        Uninterruptibles.sleepUninterruptibly((long)miliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void waitForPageToLoad() {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(AbstractDriver.TIMEOUT_SECONDS)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
            }
        });
    }

    public void waitForListItemToLoad_Contains(final EnhancedBy list, final String option) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(AbstractDriver.TIMEOUT_SECONDS)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return Helper.list.isContainedInList(list, option);
                }
            });
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void waitForTextToLoad(EnhancedBy target, String text) {
        this.waitForTextToLoad(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public void waitForTextToLoad(final EnhancedBy target, int time, final String text) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return Element.findElements(target).getText().contains(text);
                }
            });
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public boolean waitForElementToBeClickable(EnhancedBy selector) {
        return this.waitForElementToBeClickable(selector, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeClickable(final EnhancedBy target, int time) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    EnhancedWebElement elements = Element.findElements(target);
                    return elements.count() >= 1 && elements.isEnabled();
                }
            });
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS) {
                AssertHelper.assertTrue("element: " + target.name + " did not display in allowed time (s) " + time, false);
            }
            e.getMessage();
            return false;
        }
        return true;
    }

    public boolean waitForClassContain(EnhancedBy target, int index, String value) {
        return this.waitForClassContain(target, index, value, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForClassContain(final EnhancedBy target, final int index, final String value, int time) {
        FluentWait wait = new FluentWait((Object)AbstractDriver.getWebDriver()).withTimeout(Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).ignoring(NoSuchElementException.class);
        try {
            wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    EnhancedWebElement elements = Element.findElements(target);
                    return elements.getAttribute(index, "class").contains(value);
                }
            });
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS) {
                AssertHelper.assertTrue("element: " + target.name + " did not display in allowed time (s) " + time, false);
            }
            e.getMessage();
            return false;
        }
        return true;
    }
}

