/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;

public class VerifyHelper {
    protected static void verifyElementIsDisplayed(EnhancedBy by) {
        Helper.wait.waitForElementToLoad(by, 3);
        Helper.mobile.mobile_scrollToElement(by);
        TestLog.logPass("I verify '" + by.name + "' is displayed", new Object[0]);
        Helper.wait.waitForElementToLoad(by);
        EnhancedWebElement elements = Element.findElements(by);
        AssertHelper.assertTrue("element '" + by.name + "' is not displayed", elements.count() > 0);
    }

    protected static boolean isPresent(EnhancedBy element) {
        EnhancedWebElement expectedElement = Element.findElements(element);
        expectedElement.scrollToView();
        TestLog.ConsoleLog("isPresent:  " + element.name + " :" + expectedElement.isExist(new int[0]), new Object[0]);
        return expectedElement.isExist(new int[0]);
    }

    protected static boolean isElementContainingText(EnhancedBy element, String text) {
        return Helper.list.isContainedInList(element, text);
    }

    protected static void verifyElementContainingText(EnhancedBy element, String text) {
        Helper.waitForElementToLoad(element);
        Helper.assertTrue("element does not contain text: " + text, VerifyHelper.isElementContainingText(element, text));
    }

    protected static void verifyTextDisplayed(String text) {
        boolean isText = VerifyHelper.isTextDisplayed(text);
        Helper.assertTrue("text: text is not displayed", isText);
    }

    protected static boolean isTextDisplayed(String text) {
        try {
            boolean b = AbstractDriver.getWebDriver().getPageSource().contains(text);
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static void verifyElementIsNotDisplayed(EnhancedBy by) {
        EnhancedWebElement elements = Element.findElements(by);
        TestLog.logPass("I verify element '" + by.name + "' is not displayed", new Object[0]);
        Helper.wait.waitForElementToBeRemoved(by);
        AssertHelper.assertTrue("element '" + by.name + "' is displayed", !elements.isExist(new int[0]));
    }

    protected static void verifyElementText(EnhancedBy by, String value) {
        if (!value.isEmpty()) {
            Helper.wait.waitForElementToLoad(by);
            EnhancedWebElement elements = Element.findElements(by);
            Helper.assertTrue("text value not found expected: " + value + " actual: " + elements.get(0).getText(), elements.get(0).getText().equals(value));
        }
    }

    protected static void verifyElementCount(EnhancedBy by, int value, int ... correction) {
        int correctValue = 0;
        if (correction.length > 0) {
            correctValue = correction[0];
        }
        TestLog.logPass("I verify element '" + by.name + "'  occurs " + (value - correctValue) + " times", new Object[0]);
        Helper.wait.waitForElementToLoad(by, AbstractDriver.TIMEOUT_SECONDS, value);
        int count = Helper.list.getListCount(by);
        Helper.assertEquals(value, count);
    }
}

