/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Element;
import core.support.logger.TestLog;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import org.openqa.selenium.Dimension;

public class ElementHelper {
    protected static String getAttribute(EnhancedBy byValue, String attribute) {
        return ElementHelper.getAttribute(byValue, 0, attribute);
    }

    protected static String getAttribute(EnhancedBy byValue, int index, String attribute) {
        EnhancedWebElement element = Element.findElements(byValue);
        return element.getAttribute(attribute, index);
    }

    protected static boolean isElementContainingClass(EnhancedBy by, String value) {
        return ElementHelper.isAttributeContaining(by, "class", value);
    }

    protected static boolean isAttributeContaining(EnhancedBy by, String attribute, String value) {
        String attributeValues = ElementHelper.getAttribute(by, 0, attribute);
        return attributeValues.contains(value);
    }

    protected static void setAttribute(EnhancedBy by, String attribute, String value) {
        EnhancedWebElement element = Element.findElements(by);
        element.setAttribute(attribute, value);
    }

    protected static Dimension getElementSize(EnhancedBy by) {
        EnhancedWebElement element = Element.findElements(by);
        return element.getSize();
    }

    protected static int[] findMiddleOfElement(EnhancedBy target) {
        EnhancedWebElement targetElement = Element.findElements(target);
        int x = targetElement.get((int)0).getRect().x + targetElement.get((int)0).getRect().width / 2;
        int y = targetElement.get((int)0).getRect().y + targetElement.get((int)0).getRect().height / 2;
        TestLog.ConsoleLog("Center at: point x: " + x + " point y: " + y, new Object[0]);
        return new int[]{x, y};
    }
}

