/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.util.List;

public class RestApiInterface {
    private static final String AUTHORIZATION_HEADER = "Authorization";

    public static Response RestfullApiInterface(ServiceObject apiObject) {
        if (apiObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        RestApiInterface.setURI(apiObject);
        Response response = RestApiInterface.evaluateRequest(apiObject);
        RestApiInterface.validateResponse(response, apiObject);
        return response;
    }

    public static void setURI(ServiceObject apiObject) {
        apiObject.withUriPath(DataHelper.replaceParameters(apiObject.getUriPath()));
        apiObject.withUriPath(Helper.stringRemoveLines(apiObject.getUriPath()));
        if (apiObject.getUriPath().startsWith("http")) {
            RestAssured.baseURI = apiObject.getUriPath();
            apiObject.withUriPath("");
        } else {
            RestAssured.baseURI = Helper.stringRemoveLines(Config.getValue("api.uriPath"));
            TestLog.logPass("request URI: " + RestAssured.baseURI + apiObject.getUriPath(), new Object[0]);
        }
    }

    public static void validateResponse(Response response, ServiceObject apiObject) {
        if (response == null) {
            Helper.assertTrue("no response returned", false);
        }
        JsonHelper.saveOutboundJsonParameters(response, apiObject.getOutputParams());
        if (!apiObject.getRespCodeExp().isEmpty()) {
            TestLog.logPass("expected status code: " + apiObject.getRespCodeExp() + " response status code: " + response.getStatusCode(), new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(Integer.valueOf(apiObject.getRespCodeExp()).intValue());
        }
        RestApiInterface.validateExpectedValues(response, apiObject);
    }

    public static void validateExpectedValues(Response response, ServiceObject apiObject) {
        String body = response.getBody().asString();
        TestLog.logPass("response: " + body, new Object[0]);
        if (!apiObject.getExpectedResponse().isEmpty()) {
            String[] criteria;
            apiObject.withExpectedResponse(DataHelper.replaceParameters(apiObject.getExpectedResponse()));
            for (String criterion : criteria = apiObject.getExpectedResponse().split("&&")) {
                Helper.assertTrue("expected is not valid format: " + criterion, JsonHelper.isValidExpectation(criterion));
                JsonHelper.validateByJsonBody(criterion, response);
                JsonHelper.validateByKeywords(criterion, response);
                JsonHelper.validateResponseBody(criterion, response);
            }
        }
    }

    public static RequestSpecification evaluateRequestHeaders(ServiceObject apiObject) {
        RequestSpecification request = RestAssured.given();
        if (apiObject.getRequestHeaders().isEmpty()) {
            return request;
        }
        apiObject.withRequestHeaders(DataHelper.replaceParameters(apiObject.getRequestHeaders()));
        List<KeyValue> keywords = DataHelper.getValidationMap(apiObject.getRequestHeaders());
        block10: for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "auth": {
                    String value = (String)keyword.value;
                    value = value.replace("$", "").replace("<", "").replace(">", "").trim();
                    RestAssured.authentication = (AuthenticationScheme)Config.getObjectValue(value.replace("@", ""));
                    continue block10;
                }
                case "INVALID_TOKEN": {
                    String authValue = Config.getValue(AUTHORIZATION_HEADER);
                    if (!authValue.isEmpty() && authValue.length() > 4) {
                        authValue = authValue.substring(0, authValue.length() - 4) + "invalid";
                        request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)"invalid", new Object[0]);
                        continue block10;
                    }
                    request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)"invalid", new Object[0]);
                    continue block10;
                }
                case "NO_TOKEN": {
                    request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)"", new Object[0]);
                    continue block10;
                }
            }
            request = RestAssured.given().header(keyword.key, keyword.value, new Object[0]);
            if (!keyword.key.equals(AUTHORIZATION_HEADER)) continue;
            Config.putValue(AUTHORIZATION_HEADER, (String)keyword.value);
        }
        return request;
    }

    public static RequestSpecification evaluateRequestBody(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getRequestBody().isEmpty()) {
            return request;
        }
        request = request.contentType(apiObject.getContentType());
        if (apiObject.getContentType().contains("form")) {
            String[] formData;
            request = request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("multipart/form-data", ContentType.TEXT)));
            for (String data : formData = apiObject.getRequestBody().split(",")) {
                String[] keyValue = data.split(":");
                if (keyValue.length == 3) {
                    switch (keyValue[1]) {
                        case "FILE": {
                            File file = DataHelper.getFile(keyValue[2]);
                            request.multiPart(file);
                            break;
                        }
                    }
                    continue;
                }
                request = request.formParam(keyValue[0].trim(), new Object[]{keyValue[1].trim()});
            }
            return request;
        }
        return request.body(apiObject.getRequestBody());
    }

    public static RequestSpecification evaluateOption(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getOption().isEmpty()) {
            return request;
        }
        apiObject.withOption(DataHelper.replaceParameters(apiObject.getOption()));
        switch (apiObject.getOption()) {
            default: 
        }
        return request;
    }

    public static Response evaluateRequest(ServiceObject apiObject) {
        Response response = null;
        RequestSpecification request = RestApiInterface.evaluateRequestHeaders(apiObject);
        request = RestApiInterface.evaluateRequestBody(apiObject, request);
        request = RestApiInterface.evaluateOption(apiObject, request);
        TestLog.logPass("request body: " + Helper.stringRemoveLines(apiObject.getRequestBody()), new Object[0]);
        TestLog.logPass("request type: " + apiObject.getMethod(), new Object[0]);
        switch (apiObject.getMethod()) {
            case "POST": {
                response = (Response)request.when().post(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PUT": {
                response = (Response)request.when().put(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PATCH": {
                response = (Response)request.when().patch(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "DELETE": {
                response = (Response)request.when().delete(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "GET": {
                response = (Response)request.when().get(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "OPTIONS": {
                response = (Response)request.when().options(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "HEAD": {
                response = (Response)request.when().head(apiObject.getUriPath(), new Object[0]);
                break;
            }
            default: {
                Helper.assertTrue("request type not found", false);
            }
        }
        TestLog.logPass("response: " + response.getBody().asString(), new Object[0]);
        return (Response)((ValidatableResponse)response.then()).extract().response();
    }
}

