/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.DataHelper;
import core.support.logger.TestLog;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlHelper {
    public static String convertDocumentToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (IllegalArgumentException | TransformerException ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    public static Document convertXmlStringToDocument(String xmlStr) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String convertXmlFileToString(Path filePath) {
        return XmlHelper.convertDocumentToString(XmlHelper.readFile(filePath.toString()));
    }

    public static synchronized Document readFile(String inputFilePath) {
        Document doc = null;
        int retry = 3;
        do {
            try {
                --retry;
                String inputFileContents = new String(Files.readAllBytes(Paths.get(inputFilePath, new String[0])));
                inputFileContents = DataHelper.replaceParameters(inputFileContents);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                doc = dBuilder.parse(new InputSource(new StringReader(inputFileContents)));
                doc.getDocumentElement().normalize();
            }
            catch (Exception ex) {
                Thread.interrupted();
            }
        } while (doc == null && retry > 0);
        return doc;
    }

    public static String getNodeValue(String xpathString, String xmlString) {
        return XmlHelper.getNodeList(xpathString, xmlString).item(0).getTextContent();
    }

    public static NodeList getNodeList(String xpathString, String xmlString) {
        try {
            Document doc = XmlHelper.convertXmlStringToDocument(xmlString);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xpath.evaluate(xpathString, doc, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() != 0) {
                return nodeList;
            }
            TestLog.ConsoleLog("No node found for xpath value: {0}", xpathString);
        }
        catch (XPathExpressionException ex) {
            TestLog.logWarning("Exception encountered for xpath value: " + xpathString, ex);
        }
        return null;
    }

    public static void addOutputParamValuesToConfig(String outputParams, String responseBody) {
    }

    public ArrayList<String> getXPaths(String xmlString) {
        ArrayList<String> xPathList = null;
        return xPathList;
    }
}

