/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.TestObject;
import io.netty.util.internal.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataHelper {
    public static final String VERIFY_JSON_PART_INDICATOR = "_VERIFY.JSON.PART_";
    public static final String VERIFY_RESPONSE_BODY_INDICATOR = "_VERIFY.RESPONSE.BODY_";

    public static String replaceParameters(String source) {
        if (source.isEmpty()) {
            return source;
        }
        List<String> parameters = Helper.getValuesFromPattern(source, "<(.+?)>");
        String valueStr = null;
        Object val = null;
        int length = 0;
        for (String parameter : parameters) {
            if (parameter.contains("$")) continue;
            if (parameter.contains("@_TIME")) {
                length = DataHelper.getIntFromString(parameter);
                valueStr = TestObject.getTestInfo().startTime.substring(0, length);
            } else if (parameter.contains("@_RAND")) {
                length = DataHelper.getIntFromString(parameter);
                valueStr = TestObject.getTestInfo().randStringIdentifier.substring(0, length);
            } else {
                val = Config.getObjectValue(parameter.replace("@", ""));
                if (val instanceof String) {
                    valueStr = (String)val;
                }
            }
            if (StringUtil.isNullOrEmpty((String)valueStr)) {
                Helper.assertTrue("parameter value not found: " + parameter, false);
            }
            if (!(valueStr instanceof String)) continue;
            source = source.replaceAll("<" + parameter + ">", Matcher.quoteReplacement(valueStr));
        }
        return source;
    }

    public static int getIntFromString(String value) {
        return Integer.parseInt(value.replaceAll("[\\D]", ""));
    }

    public static List<KeyValue> getValidationMap(String expected) {
        ArrayList<KeyValue> keywords = new ArrayList<KeyValue>();
        expected = expected.replaceFirst("_[^_]*_", "");
        String[] keyVals = expected.split(";");
        String key = "";
        String position = "";
        String value = "";
        for (String keyVal : keyVals) {
            String[] parts = keyVal.split(":", 3);
            if (parts.length == 1) {
                key = Helper.stringRemoveLines(parts[0]);
            }
            if (parts.length == 2) {
                key = Helper.stringRemoveLines(parts[0]);
                position = "";
                value = Helper.stringRemoveLines(parts[1]);
            } else if (parts.length == 3) {
                key = Helper.stringRemoveLines(parts[0]);
                position = Helper.stringRemoveLines(parts[1]);
                value = Helper.stringRemoveLines(parts[2]);
            }
            if (key.isEmpty()) continue;
            KeyValue keyword = new KeyValue(key, position, value);
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String getTagValue(String requestBody, String tag) {
        String value = "";
        try {
            String patternString = ":" + tag + ">(.+?)</";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(requestBody);
            matcher.find();
            value = matcher.group(1);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return value;
    }

    public static String getTemplateFile(String file) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        return templateTestPath + file;
    }

    public static File getFile(String filename) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        File file = new File(templateTestPath + filename);
        return file;
    }

    public static String convertTemplateToString(String templateFilePath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(new File(templateFilePath)));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line.trim());
        }
        br.close();
        return sb.toString();
    }

    public static void addOutputMessageToConfigParams(String outputParams, String outboundMsg) {
        String key = StringUtils.substringBetween((String)outputParams, (String)"<$", (String)">");
        Config.putValue(key, outboundMsg);
        TestLog.logPass("Get Service Bus Outbound Message:{0}", Config.getValue(key));
    }

    public static void validateCommand(String command, String responseString, String expectedString) {
        DataHelper.validateCommand(command, responseString, expectedString, "");
    }

    public static void validateCommand(String command, String responseString, String expectedString, String position) {
        Object[] expectedArray = expectedString.split(",");
        Object[] actualArray = responseString.split(",");
        Object actualString = "";
        if (!position.isEmpty()) {
            boolean inBounds;
            int positionInt = Integer.valueOf(position);
            expectedString = expectedArray[0];
            boolean bl = inBounds = positionInt > 0 && positionInt <= actualArray.length;
            if (!inBounds) {
                Helper.assertFalse("items returned are less than specified. returned: " + actualArray.length + " specified: " + positionInt);
            }
            actualString = actualArray[positionInt - 1];
        }
        switch (command) {
            case "hasItems": {
                boolean val = false;
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " has item " + expectedString, new Object[0]);
                    val = ((String)actualString).contains(expectedString);
                    Helper.assertTrue((String)actualString + " does not have item " + expectedString, val);
                    break;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " has items " + Arrays.toString(expectedArray), new Object[0]);
                val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                Helper.assertTrue(Arrays.toString(actualArray) + " does not have items " + Arrays.toString(expectedArray), val);
                break;
            }
            case "equalTo": {
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " equals " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).equals(expectedString);
                    Helper.assertTrue((String)actualString + " does not equal " + expectedString, val);
                    break;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " equals " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                Helper.assertTrue(Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray), val);
                break;
            }
            case "contains": {
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " contains " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).contains(expectedString);
                    Helper.assertTrue((String)actualString + " does not contain " + expectedString, val);
                    break;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                Helper.assertTrue(Arrays.toString(actualArray) + " does not contain " + Arrays.toString(expectedArray), val);
                break;
            }
            case "containsInAnyOrder": {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains any order " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                Helper.assertTrue(Arrays.toString(actualArray) + " does not contain in any order " + Arrays.toString(expectedArray), val);
                break;
            }
            case "nodeSizeGreaterThan": {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " greater than " + intValue, new Object[0]);
                Helper.assertTrue("response node size is: " + actualArray.length + " expected it to be greated than: " + intValue, actualArray.length > intValue);
                break;
            }
            case "nodeSizeExact": {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " equals " + intValue, new Object[0]);
                Helper.assertTrue("response node size is: " + actualArray.length + " expected: " + intValue, actualArray.length == intValue);
                break;
            }
            case "sequence": {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " with sequence " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                Helper.assertTrue(Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray), val);
                break;
            }
            case "isNotEmpty": {
                TestLog.logPass("verifying response for path is not empty", new Object[0]);
                Helper.assertTrue("value is empty", !responseString.isEmpty());
                break;
            }
            case "isEmpty": {
                TestLog.logPass("verifying response for path is empty ", new Object[0]);
                Helper.assertTrue("value is not empty", responseString.isEmpty());
                break;
            }
        }
    }
}

