/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.driver;

import core.apiCore.helpers.CsvReader;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;

public class ApiTestDriver {
    public static void setTestId(ServiceObject apiObject) {
        String csvFileName = ApiTestDriver.getTestClass(apiObject);
        TestObject.setTestName(apiObject.getTestCaseID());
        TestObject.setTestId(csvFileName + "-" + apiObject.getTestCaseID());
    }

    public static String getTestClass(ServiceObject apiObject) {
        String testClass = apiObject.getTcName();
        testClass = testClass.split("\\.")[0];
        testClass = testClass.replace("TestCases_", "");
        return testClass;
    }

    public void initTest(ServiceObject apiObject) {
        String APP = "ServiceManager";
        ApiTestDriver.setTestId(apiObject);
        String testId = TestObject.currentTestId.get();
        TestLog.removeLogUtilHandler();
        String classname = ApiTestDriver.getTestClass(apiObject);
        TestObject.initializeTest(classname);
        TestObject.initializeTest(testId);
        TestObject.getTestInfo().config = TestObject.getTestInfo((String)classname).config;
        TestObject.getTestInfo().testLog = TestObject.getTestInfo((String)classname).testLog;
        TestObject.getTestInfo().type = TestObject.testType.apiTest;
        TestObject.getTestInfo().app = APP;
        TestObject.getTestInfo().testCsvFileName = apiObject.getTcName();
        TestObject.getTestInfo().className = ApiTestDriver.getTestClass(apiObject);
        TestObject.getTestInfo().testName = apiObject.getTestCaseID();
        TestObject.getTestInfo().currentTestIndex = Integer.valueOf(apiObject.getTcIndex());
        if (TestObject.getTestInfo().testCountInCsvFile == 0) {
            TestObject.getTestInfo().testCountInCsvFile = CsvReader.getCsvTestListForTestRunner(apiObject.getTcName()).size();
        }
    }

    public static boolean isTestComplete() {
        if (TestObject.getTestInfo().currentTestIndex == CsvReader.getCsvTestcount()) {
            TestObject.getTestInfo().isTestComplete = true;
            return true;
        }
        return false;
    }

    public String getClassName() {
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        return className;
    }
}

