/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.aws.s3;

import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import io.atlassian.aws.AmazonExceptions;
import io.atlassian.aws.AmazonRegion$;
import io.atlassian.aws.Types;
import io.atlassian.aws.package;
import io.atlassian.aws.s3.ContentLocation;
import io.atlassian.aws.s3.InputStreams;
import io.atlassian.aws.s3.InputStreams$;
import io.atlassian.aws.s3.InputStreams$ReadBytes$End$;
import io.atlassian.aws.s3.Range;
import io.atlassian.aws.s3.Range$All$;
import io.atlassian.aws.s3.S3$;
import io.atlassian.aws.s3.S3$$anonfun$io$atlassian$aws$s3$S3$;
import io.atlassian.aws.s3.S3$$anonfun$io$atlassian$aws$s3$S3$$forceCopy$2$;
import io.atlassian.aws.s3.S3$$anonfun$putStreamWithMultipart$3$;
import io.atlassian.aws.s3.S3$$anonfun$putStreamWithMultipart$3$$anonfun$apply$6$;
import io.atlassian.aws.s3.S3Action$;
import io.atlassian.aws.s3.package$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import kadai.Attempt;
import kadai.Invalid;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalaz.Applicative;
import scalaz.Bind;
import scalaz.Functor;
import scalaz.Kleisli;
import scalaz.Kleisli$;
import scalaz.Monad;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.std.list$;
import scalaz.std.option$;
import scalaz.syntax.std.package;

public final class S3$ {
    public static final S3$ MODULE$;
    private final int MultipartChunkSize;

    static {
        new S3$();
    }

    public int MultipartChunkSize() {
        return this.MultipartChunkSize;
    }

    public Kleisli<Attempt, AmazonS3, S3Object> get(ContentLocation location, Range range) {
        return S3Action$.MODULE$.withClient(new Serializable(location, range){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$1;
            public final Range range$1;

            public final S3Object apply(AmazonS3 x$1) {
                return x$1.getObject((GetObjectRequest)scalaz.syntax.package$.MODULE$.id().ToIdOpsDeprecated((Object)new GetObjectRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$1.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$1.key())))).$less$bar((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.get.1 $outer;

                    public final void apply(GetObjectRequest req) {
                        this.$outer.range$1.get().foreach((Function1)new Serializable(this, req){
                            public static final long serialVersionUID = 0L;
                            private final GetObjectRequest req$1;

                            public final void apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    long from = tuple2._1$mcJ$sp();
                                    long to = tuple2._2$mcJ$sp();
                                    this.req$1.setRange(from, to);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.req$1 = req$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.location$1 = location$1;
                this.range$1 = range$1;
            }
        });
    }

    public Range get$default$2() {
        return Range$All$.MODULE$;
    }

    public Kleisli<Attempt, AmazonS3, Option<S3Object>> safeGet(ContentLocation location, Range range) {
        return io.atlassian.aws.package$.MODULE$.AwsAction().AwsActionOps(this.get(location, range).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<S3Object> apply(S3Object a) {
                return option$.MODULE$.some((Object)a);
            }
        }, (Functor)Attempt.AttemptMonad$.MODULE$)).handle((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Invalid, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Kleisli<Attempt, AmazonS3, None$> kleisli;
                Invalid.Err err;
                Throwable throwable;
                A1 A1 = x1;
                if (A1 instanceof Invalid.Err && (throwable = (err = (Invalid.Err)A1).x()) instanceof AmazonExceptions.ServiceException) {
                    AmazonExceptions.ServiceException serviceException = (AmazonExceptions.ServiceException)throwable;
                    AmazonExceptions.ExceptionType exceptionType = serviceException.exceptionType();
                    AmazonExceptions.ExceptionType$.NotFound$ notFound$ = AmazonExceptions.ExceptionType$.NotFound$.MODULE$;
                    AmazonExceptions.ExceptionType exceptionType2 = exceptionType;
                    if (!(notFound$ != null ? !notFound$.equals(exceptionType2) : exceptionType2 != null)) {
                        kleisli = S3Action$.MODULE$.ok(None$.MODULE$);
                        return (B1)kleisli;
                    }
                }
                kleisli = function1.apply(x1);
                return (B1)kleisli;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Invalid x1) {
                Invalid invalid = x1;
                if (!(invalid instanceof Invalid.Err)) return false;
                Invalid.Err err = (Invalid.Err)invalid;
                Throwable throwable = err.x();
                if (!(throwable instanceof AmazonExceptions.ServiceException)) return false;
                AmazonExceptions.ServiceException serviceException = (AmazonExceptions.ServiceException)throwable;
                AmazonExceptions.ExceptionType exceptionType = serviceException.exceptionType();
                AmazonExceptions.ExceptionType$.NotFound$ notFound$ = AmazonExceptions.ExceptionType$.NotFound$.MODULE$;
                AmazonExceptions.ExceptionType exceptionType2 = exceptionType;
                if (notFound$ != null) {
                    if (!notFound$.equals(exceptionType2)) return false;
                    return true;
                }
                if (exceptionType2 == null) return true;
                return false;
            }
        });
    }

    public Range safeGet$default$2() {
        return Range$All$.MODULE$;
    }

    public Kleisli<Attempt, AmazonS3, PutObjectResult> putStream(ContentLocation location, InputStream stream, Option<Object> length, ObjectMetadata metaData2, boolean createFolders) {
        return ((Kleisli)package.boolean$.MODULE$.ToBooleanOpsFromBoolean(createFolders).whenM((Function0)new Serializable(location){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$2;

            public final Kleisli<Attempt, AmazonS3, List<PutObjectResult>> apply() {
                return S3$.MODULE$.createFoldersFor(this.location$2);
            }
            {
                this.location$2 = location$2;
            }
        }, (Applicative)Kleisli$.MODULE$.kleisliMonadReader((Monad)Attempt.AttemptMonad$.MODULE$))).map((Function1)new Serializable(length, metaData2){
            public static final long serialVersionUID = 0L;
            private final Option length$1;
            public final ObjectMetadata metaData$1;

            public final Tuple2<BoxedUnit, BoxedUnit> apply(BoxedUnit x$3) {
                this.length$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.putStream.2 $outer;

                    public final void apply(long x$1) {
                        this.apply$mcVJ$sp(x$1);
                    }

                    public void apply$mcVJ$sp(long x$1) {
                        this.$outer.metaData$1.setContentLength(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit x$4 = BoxedUnit.UNIT;
                return new Tuple2((Object)x$3, (Object)x$4);
            }
            {
                this.length$1 = length$1;
                this.metaData$1 = metaData$1;
            }
        }, (Functor)Attempt.AttemptMonad$.MODULE$).flatMap((Function1)new Serializable(location, stream, metaData2){
            public static final long serialVersionUID = 0L;
            public final ContentLocation location$2;
            public final InputStream stream$1;
            public final ObjectMetadata metaData$1;

            public final Kleisli<Attempt, AmazonS3, PutObjectResult> apply(Tuple2<BoxedUnit, BoxedUnit> x$5) {
                Tuple2<BoxedUnit, BoxedUnit> tuple2 = x$5;
                if (tuple2 != null) {
                    Kleisli kleisli = S3Action$.MODULE$.withClient(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.putStream.3 $outer;

                        public final PutObjectResult apply(AmazonS3 x$2) {
                            return x$2.putObject((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.location$2.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.location$2.key())), this.$outer.stream$1, this.$outer.metaData$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final PutObjectResult apply(PutObjectResult putResult) {
                            return putResult;
                        }
                    }, (Functor)Attempt.AttemptMonad$.MODULE$);
                    return kleisli;
                }
                throw new MatchError(tuple2);
            }
            {
                this.location$2 = location$2;
                this.stream$1 = stream$1;
                this.metaData$1 = metaData$1;
            }
        }, (Bind)Attempt.AttemptMonad$.MODULE$);
    }

    public Option<Object> putStream$default$3() {
        return None$.MODULE$;
    }

    public ObjectMetadata putStream$default$4() {
        return this.DefaultObjectMetadata();
    }

    public boolean putStream$default$5() {
        return true;
    }

    public Kleisli<Attempt, AmazonS3, Object> putStreamWithMultipart(ContentLocation location, InputStream stream, Option<Object> length, ObjectMetadata metaData2, boolean createFolders) {
        Option<Object> option;
        block4: {
            Kleisli kleisli;
            block3: {
                block2: {
                    option = length;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    long contentLength = BoxesRunTime.unboxToLong((Object)some.x());
                    kleisli = this.putStream(location, stream, length, metaData2, createFolders).map((Function1)new Serializable(contentLength){
                        public static final long serialVersionUID = 0L;
                        private final long contentLength$1;

                        public final Object apply(PutObjectResult _) {
                            return package$.MODULE$.ContentLength().apply(BoxesRunTime.boxToLong((long)this.contentLength$1));
                        }
                        {
                            this.contentLength$1 = contentLength$1;
                        }
                    }, (Functor)Attempt.AttemptMonad$.MODULE$);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                kleisli = ((Kleisli)package.boolean$.MODULE$.ToBooleanOpsFromBoolean(createFolders).whenM((Function0)new Serializable(location){
                    public static final long serialVersionUID = 0L;
                    private final ContentLocation location$4;

                    public final Kleisli<Attempt, AmazonS3, List<PutObjectResult>> apply() {
                        return S3$.MODULE$.createFoldersFor(this.location$4);
                    }
                    {
                        this.location$4 = location$4;
                    }
                }, (Applicative)Kleisli$.MODULE$.kleisliMonadReader((Monad)Attempt.AttemptMonad$.MODULE$))).flatMap((Function1)new Serializable(location, stream, metaData2){
                    public static final long serialVersionUID = 0L;
                    public final ContentLocation location$4;
                    public final InputStream stream$2;
                    public final ObjectMetadata metaData$2;

                    public final Kleisli<Attempt, AmazonS3, Object> apply(BoxedUnit _) {
                        return S3Action$.MODULE$.withClient(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.putStreamWithMultipart.3 $outer;

                            public final InitiateMultipartUploadResult apply(AmazonS3 x$6) {
                                return x$6.initiateMultipartUpload(new InitiateMultipartUploadRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.location$4.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.location$4.key())), this.$outer.metaData$2));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.putStreamWithMultipart.3 $outer;

                            public final Kleisli<Attempt, AmazonS3, Object> apply(InitiateMultipartUploadResult initResult) {
                                return io.atlassian.aws.package$.MODULE$.AwsAction().AwsActionOps(S3$.MODULE$.putChunks(this.$outer.location$4, this.$outer.stream$2, initResult.getUploadId(), new byte[S3$.MODULE$.MultipartChunkSize()])).recover((Function1)new Serializable(this, initResult){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6 $outer;
                                    public final InitiateMultipartUploadResult initResult$1;

                                    public final Kleisli<Attempt, AmazonS3, Tuple2<List<PartETag>, Object>> apply(Invalid i) {
                                        return S3Action$.MODULE$.withClient(new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6$$anonfun$apply$7 $outer;

                                            public final void apply(AmazonS3 x$7) {
                                                x$7.abortMultipartUpload(new AbortMultipartUploadRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer().io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().location$4.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer().io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().location$4.key())), this.$outer.initResult$1.getUploadId()));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        }).flatMap((Function1)new Serializable(this, i){
                                            public static final long serialVersionUID = 0L;
                                            private final Invalid i$1;

                                            public final Kleisli<Attempt, AmazonS3, Tuple2<List<PartETag>, Object>> apply(BoxedUnit x$8) {
                                                return S3Action$.MODULE$.fail(this.i$1);
                                            }
                                            {
                                                this.i$1 = i$1;
                                            }
                                        }, (Bind)Attempt.AttemptMonad$.MODULE$);
                                    }

                                    public /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6 io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.initResult$1 = initResult$1;
                                    }
                                }).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<Tuple2<List<PartETag>, Object>, Tuple2<List<PartETag>, Object>> apply(Tuple2<List<PartETag>, Object> putResult) {
                                        Tuple2<List<PartETag>, Object> tuple2 = putResult;
                                        if (tuple2 != null) {
                                            Tuple3 tuple3;
                                            List parts = (List)tuple2._1();
                                            long contentLength = tuple2._2$mcJ$sp();
                                            Tuple3 tuple32 = tuple3 = new Tuple3(tuple2, (Object)parts, (Object)BoxesRunTime.boxToLong((long)contentLength));
                                            Tuple2 x$10 = (Tuple2)tuple32._1();
                                            List parts2 = (List)tuple32._2();
                                            long contentLength2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
                                            return new Tuple2(putResult, (Object)x$10);
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, (Functor)Attempt.AttemptMonad$.MODULE$).flatMap((Function1)new Serializable(this, initResult){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6 $outer;
                                    public final InitiateMultipartUploadResult initResult$1;

                                    public final Kleisli<Attempt, AmazonS3, Object> apply(Tuple2<Tuple2<List<PartETag>, Object>, Tuple2<List<PartETag>, Object>> x$12) {
                                        Tuple2 tuple2;
                                        Tuple2<Tuple2<List<PartETag>, Object>, Tuple2<List<PartETag>, Object>> tuple22 = x$12;
                                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                                            List parts = (List)tuple2._1();
                                            long contentLength = tuple2._2$mcJ$sp();
                                            Kleisli kleisli = S3Action$.MODULE$.withClient(new Serializable(this, parts){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6$$anonfun$apply$11 $outer;
                                                private final List parts$1;

                                                public final CompleteMultipartUploadResult apply(AmazonS3 x$9) {
                                                    return x$9.completeMultipartUpload(new CompleteMultipartUploadRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer().io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().location$4.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer().io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().location$4.key())), this.$outer.initResult$1.getUploadId(), new ArrayList<E>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.parts$1).asJava())));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.parts$1 = parts$1;
                                                }
                                            }).map((Function1)new Serializable(this, contentLength){
                                                public static final long serialVersionUID = 0L;
                                                private final long contentLength$2;

                                                public final Object apply(CompleteMultipartUploadResult compResult) {
                                                    return package$.MODULE$.ContentLength().apply(BoxesRunTime.boxToLong((long)this.contentLength$2));
                                                }
                                                {
                                                    this.contentLength$2 = contentLength$2;
                                                }
                                            }, (Functor)Attempt.AttemptMonad$.MODULE$);
                                            return kleisli;
                                        }
                                        throw new MatchError(tuple22);
                                    }

                                    public /* synthetic */ anonfun$putStreamWithMultipart$3$$anonfun$apply$6 io$atlassian$aws$s3$S3$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.initResult$1 = initResult$1;
                                    }
                                }, (Bind)Attempt.AttemptMonad$.MODULE$);
                            }

                            public /* synthetic */ anonfun.putStreamWithMultipart.3 io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Bind)Attempt.AttemptMonad$.MODULE$);
                    }
                    {
                        this.location$4 = location$4;
                        this.stream$2 = stream$2;
                        this.metaData$2 = metaData$2;
                    }
                }, (Bind)Attempt.AttemptMonad$.MODULE$);
            }
            return kleisli;
        }
        throw new MatchError(option);
    }

    public Option<Object> putStreamWithMultipart$default$3() {
        return None$.MODULE$;
    }

    public ObjectMetadata putStreamWithMultipart$default$4() {
        return this.DefaultObjectMetadata();
    }

    public boolean putStreamWithMultipart$default$5() {
        return true;
    }

    public Kleisli<Attempt, AmazonS3, Tuple2<List<PartETag>, Object>> putChunks(ContentLocation location, InputStream stream, String uploadId, byte[] buffer) {
        return S3Action$.MODULE$.withClient(new Serializable(location, stream, uploadId, buffer){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$5;
            private final InputStream stream$3;
            private final String uploadId$1;
            private final byte[] buffer$1;

            public final Tuple2<List<PartETag>, Object> apply(AmazonS3 client) {
                return (Tuple2)this.io$atlassian$aws$s3$S3$$anonfun$$go$1((List)Nil$.MODULE$, 0L, client).run();
            }

            public final UploadPartResult io$atlassian$aws$s3$S3$$anonfun$$upload$1(int byteCount, int partNumber, AmazonS3 client$1) {
                return client$1.uploadPart(new UploadPartRequest().withBucketName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$5.bucket()))).withKey((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$5.key()))).withUploadId(this.uploadId$1).withPartNumber(partNumber).withInputStream((InputStream)new ByteArrayInputStream(this.buffer$1, 0, byteCount)).withPartSize((long)byteCount));
            }

            public final Task io$atlassian$aws$s3$S3$$anonfun$$go$1(List curTags, long curLength, AmazonS3 client$1) {
                return InputStreams$.MODULE$.readFully(this.stream$3, this.buffer$1).flatMap((Function1)new Serializable(this, client$1, curTags, curLength){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.putChunks.1 $outer;
                    private final AmazonS3 client$1;
                    private final List curTags$1;
                    private final long curLength$1;

                    public final Task<Tuple2<List<PartETag>, Object>> apply(InputStreams.ReadBytes x0$2) {
                        InputStreams.ReadBytes readBytes;
                        block4: {
                            Task task;
                            block3: {
                                block2: {
                                    readBytes = x0$2;
                                    InputStreams$ReadBytes$End$ inputStreams$ReadBytes$End$ = InputStreams$ReadBytes$End$.MODULE$;
                                    InputStreams.ReadBytes readBytes2 = readBytes;
                                    if (inputStreams$ReadBytes$End$ != null ? !inputStreams$ReadBytes$End$.equals(readBytes2) : readBytes2 != null) break block2;
                                    task = Task$.MODULE$.now((Object)new Tuple2((Object)this.curTags$1, (Object)BoxesRunTime.boxToLong((long)this.curLength$1)));
                                    break block3;
                                }
                                if (!(readBytes instanceof InputStreams.ReadBytes.Chunk)) break block4;
                                InputStreams.ReadBytes.Chunk chunk = (InputStreams.ReadBytes.Chunk)readBytes;
                                int rn = chunk.read();
                                UploadPartResult partResult = this.$outer.io$atlassian$aws$s3$S3$$anonfun$$upload$1(rn, this.curTags$1.length() + 1, this.client$1);
                                task = this.$outer.io$atlassian$aws$s3$S3$$anonfun$$go$1((List)this.curTags$1.$colon$plus((Object)partResult.getPartETag(), List$.MODULE$.canBuildFrom()), this.curLength$1 + (long)rn, this.client$1);
                            }
                            return task;
                        }
                        throw new MatchError((Object)readBytes);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.client$1 = client$1;
                        this.curTags$1 = curTags$1;
                        this.curLength$1 = curLength$1;
                    }
                });
            }
            {
                this.location$5 = location$5;
                this.stream$3 = stream$3;
                this.uploadId$1 = uploadId$1;
                this.buffer$1 = buffer$1;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, List<PutObjectResult>> createFoldersFor(ContentLocation location) {
        return (Kleisli)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps(package$.MODULE$.S3Key().S3KeySyntax(location.key()).foldersWithLeadingPaths(), list$.MODULE$.listInstance()).traverse((Function1)new Serializable(location){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$3;

            public final Kleisli<Attempt, AmazonS3, PutObjectResult> apply(String folder) {
                return S3$.MODULE$.createFolder(this.location$3.bucket(), folder, S3$.MODULE$.createFolder$default$3());
            }
            {
                this.location$3 = location$3;
            }
        }, (Applicative)Kleisli$.MODULE$.kleisliMonadReader((Monad)Attempt.AttemptMonad$.MODULE$));
    }

    public Kleisli<Attempt, AmazonS3, PutObjectResult> createFolder(Object bucket, String folder, ObjectMetadata metaData2) {
        ByteArrayInputStream dummyStream = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        return this.putStream(new ContentLocation(bucket, package$.MODULE$.S3Key().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder})))), dummyStream, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)), metaData2, false);
    }

    public ObjectMetadata createFolder$default$3() {
        return this.DefaultObjectMetadata();
    }

    public Kleisli<Attempt, AmazonS3, Option<CopyObjectResult>> copy(ContentLocation from, ContentLocation to, Option<ObjectMetadata> meta, boolean createFolders, Types.OverwriteMode overwrite) {
        Types.OverwriteMode overwriteMode;
        block4: {
            Kleisli kleisli;
            block3: {
                block2: {
                    overwriteMode = overwrite;
                    Types.OverwriteMode$.Overwrite$ overwrite$ = io.atlassian.aws.package$.MODULE$.OverwriteMode().Overwrite();
                    Types.OverwriteMode overwriteMode2 = overwriteMode;
                    if (overwrite$ != null ? !overwrite$.equals(overwriteMode2) : overwriteMode2 != null) break block2;
                    kleisli = S3Action$.MODULE$.ok(BoxesRunTime.boxToBoolean((boolean)true));
                    break block3;
                }
                Types.OverwriteMode$.NoOverwrite$ noOverwrite$ = io.atlassian.aws.package$.MODULE$.OverwriteMode().NoOverwrite();
                Types.OverwriteMode overwriteMode3 = overwriteMode;
                if (noOverwrite$ != null ? !noOverwrite$.equals(overwriteMode3) : overwriteMode3 != null) break block4;
                kleisli = this.exists(to).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$13) {
                        return !x$13;
                    }
                }, (Functor)Attempt.AttemptMonad$.MODULE$);
            }
            return kleisli.flatMap((Function1)new Serializable(from, to, meta, createFolders){
                public static final long serialVersionUID = 0L;
                private final ContentLocation from$1;
                private final ContentLocation to$1;
                private final Option meta$1;
                private final boolean createFolders$1;

                public final Kleisli<Attempt, AmazonS3, Option<CopyObjectResult>> apply(boolean doCopy) {
                    return (doCopy ? S3$.MODULE$.io$atlassian$aws$s3$S3$$forceCopy(this.from$1, this.to$1, (Option<ObjectMetadata>)this.meta$1, this.createFolders$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Option<CopyObjectResult> apply(CopyObjectResult a) {
                            return option$.MODULE$.some((Object)a);
                        }
                    }, (Functor)Attempt.AttemptMonad$.MODULE$) : S3Action$.MODULE$.ok(option$.MODULE$.none())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Option<CopyObjectResult> apply(Option<CopyObjectResult> result) {
                            return result;
                        }
                    }, (Functor)Attempt.AttemptMonad$.MODULE$);
                }
                {
                    this.from$1 = from$1;
                    this.to$1 = to$1;
                    this.meta$1 = meta$1;
                    this.createFolders$1 = createFolders$1;
                }
            }, (Bind)Attempt.AttemptMonad$.MODULE$);
        }
        throw new MatchError((Object)overwriteMode);
    }

    public Option<ObjectMetadata> copy$default$3() {
        return None$.MODULE$;
    }

    public boolean copy$default$4() {
        return true;
    }

    public Types.OverwriteMode copy$default$5() {
        return io.atlassian.aws.package$.MODULE$.OverwriteMode().Overwrite();
    }

    public Kleisli<Attempt, AmazonS3, CopyObjectResult> io$atlassian$aws$s3$S3$$forceCopy(ContentLocation from, ContentLocation to, Option<ObjectMetadata> newMetaData, boolean createFolders) {
        return ((Kleisli)package.boolean$.MODULE$.ToBooleanOpsFromBoolean(createFolders).whenM((Function0)new Serializable(to){
            public static final long serialVersionUID = 0L;
            private final ContentLocation to$2;

            public final Kleisli<Attempt, AmazonS3, List<PutObjectResult>> apply() {
                return S3$.MODULE$.createFoldersFor(this.to$2);
            }
            {
                this.to$2 = to$2;
            }
        }, (Applicative)Kleisli$.MODULE$.kleisliMonadReader((Monad)Attempt.AttemptMonad$.MODULE$))).flatMap((Function1)new Serializable(from, to, newMetaData){
            public static final long serialVersionUID = 0L;
            public final ContentLocation from$2;
            public final ContentLocation to$2;
            private final Option newMetaData$1;

            public final Kleisli<Attempt, AmazonS3, CopyObjectResult> apply(BoxedUnit _) {
                return ((Kleisli)this.newMetaData$1.fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$io$atlassian$aws$s3$S3$$forceCopy$2 $outer;

                    public final Kleisli<Attempt, AmazonS3, ObjectMetadata> apply() {
                        return S3$.MODULE$.metaData(this.$outer.from$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Kleisli<Attempt, AmazonS3, ObjectMetadata> apply(ObjectMetadata strict) {
                        return S3Action$.MODULE$.ok(strict);
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$io$atlassian$aws$s3$S3$$forceCopy$2 $outer;

                    public final Kleisli<Attempt, AmazonS3, CopyObjectResult> apply(ObjectMetadata metaData2) {
                        return S3Action$.MODULE$.withClient(new Serializable(this, metaData2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$io$atlassian$aws$s3$S3$$forceCopy$2$$anonfun$apply$18 $outer;
                            private final ObjectMetadata metaData$3;

                            public final CopyObjectResult apply(AmazonS3 x$14) {
                                return x$14.copyObject(new CopyObjectRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().from$2.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().from$2.key())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().to$2.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.$outer.io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer().to$2.key()))).withNewObjectMetadata(this.metaData$3));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.metaData$3 = metaData$3;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CopyObjectResult apply(CopyObjectResult result) {
                                return result;
                            }
                        }, (Functor)Attempt.AttemptMonad$.MODULE$);
                    }

                    public /* synthetic */ anonfun$io$atlassian$aws$s3$S3$$forceCopy$2 io$atlassian$aws$s3$S3$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Bind)Attempt.AttemptMonad$.MODULE$);
            }
            {
                this.from$2 = from$2;
                this.to$2 = to$2;
                this.newMetaData$1 = newMetaData$1;
            }
        }, (Bind)Attempt.AttemptMonad$.MODULE$);
    }

    public Kleisli<Attempt, AmazonS3, Option<ObjectMetadata>> safeMetaData(ContentLocation location) {
        return io.atlassian.aws.package$.MODULE$.AwsAction().AwsActionOps(this.metaData(location).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ObjectMetadata> apply(ObjectMetadata a) {
                return option$.MODULE$.some((Object)a);
            }
        }, (Functor)Attempt.AttemptMonad$.MODULE$)).handle((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Invalid, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Kleisli<Attempt, AmazonS3, None$> kleisli;
                Invalid.Err err;
                Throwable throwable;
                A1 A1 = x2;
                if (A1 instanceof Invalid.Err && (throwable = (err = (Invalid.Err)A1).x()) instanceof AmazonExceptions.ServiceException) {
                    AmazonExceptions.ServiceException serviceException = (AmazonExceptions.ServiceException)throwable;
                    AmazonExceptions.ExceptionType exceptionType = serviceException.exceptionType();
                    AmazonExceptions.ExceptionType$.NotFound$ notFound$ = AmazonExceptions.ExceptionType$.NotFound$.MODULE$;
                    AmazonExceptions.ExceptionType exceptionType2 = exceptionType;
                    if (!(notFound$ != null ? !notFound$.equals(exceptionType2) : exceptionType2 != null)) {
                        kleisli = S3Action$.MODULE$.ok(None$.MODULE$);
                        return (B1)kleisli;
                    }
                }
                kleisli = function1.apply(x2);
                return (B1)kleisli;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Invalid x2) {
                Invalid invalid = x2;
                if (!(invalid instanceof Invalid.Err)) return false;
                Invalid.Err err = (Invalid.Err)invalid;
                Throwable throwable = err.x();
                if (!(throwable instanceof AmazonExceptions.ServiceException)) return false;
                AmazonExceptions.ServiceException serviceException = (AmazonExceptions.ServiceException)throwable;
                AmazonExceptions.ExceptionType exceptionType = serviceException.exceptionType();
                AmazonExceptions.ExceptionType$.NotFound$ notFound$ = AmazonExceptions.ExceptionType$.NotFound$.MODULE$;
                AmazonExceptions.ExceptionType exceptionType2 = exceptionType;
                if (notFound$ != null) {
                    if (!notFound$.equals(exceptionType2)) return false;
                    return true;
                }
                if (exceptionType2 == null) return true;
                return false;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, ObjectMetadata> metaData(ContentLocation location) {
        return S3Action$.MODULE$.withClient(new Serializable(location){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$6;

            public final ObjectMetadata apply(AmazonS3 x$15) {
                return x$15.getObjectMetadata((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$6.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$6.key())));
            }
            {
                this.location$6 = location$6;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, Object> exists(ContentLocation location) {
        return this.safeMetaData(location).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<ObjectMetadata> x$16) {
                return x$16.isDefined();
            }
        }, (Functor)Attempt.AttemptMonad$.MODULE$);
    }

    public Kleisli<Attempt, AmazonS3, BoxedUnit> delete(ContentLocation location) {
        return S3Action$.MODULE$.withClient(new Serializable(location){
            public static final long serialVersionUID = 0L;
            private final ContentLocation location$7;

            public final void apply(AmazonS3 x$17) {
                x$17.deleteObject(new DeleteObjectRequest((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$7.bucket())), (String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.location$7.key()))));
            }
            {
                this.location$7 = location$7;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, ObjectListing> listKeys(Object bucket, String prefix) {
        return S3Action$.MODULE$.withClient(new Serializable(bucket, prefix){
            public static final long serialVersionUID = 0L;
            private final Object bucket$2;
            private final String prefix$1;

            public final ObjectListing apply(AmazonS3 x$18) {
                return x$18.listObjects((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.bucket$2)), this.prefix$1);
            }
            {
                this.bucket$2 = bucket$2;
                this.prefix$1 = prefix$1;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, ObjectListing> nextBatchOfKeys(ObjectListing lastListing) {
        return S3Action$.MODULE$.withClient(new Serializable(lastListing){
            public static final long serialVersionUID = 0L;
            private final ObjectListing lastListing$1;

            public final ObjectListing apply(AmazonS3 x$19) {
                return x$19.listNextBatchOfObjects(this.lastListing$1);
            }
            {
                this.lastListing$1 = lastListing$1;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, Object> exists(Object bucket) {
        return S3Action$.MODULE$.withClient(new Serializable(bucket){
            public static final long serialVersionUID = 0L;
            private final Object bucket$1;

            public final boolean apply(AmazonS3 x$20) {
                return x$20.doesBucketExist((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.bucket$1)));
            }
            {
                this.bucket$1 = bucket$1;
            }
        });
    }

    public Kleisli<Attempt, AmazonS3, Region> regionFor(Object bucket) {
        return S3Action$.MODULE$.withClient(new Serializable(bucket){
            public static final long serialVersionUID = 0L;
            private final Object bucket$3;

            public final String apply(AmazonS3 x$21) {
                return x$21.getBucketLocation((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(this.bucket$3)));
            }
            {
                this.bucket$3 = bucket$3;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Kleisli<Attempt, AmazonS3, Region> apply(String region) {
                Object object;
                String string = region;
                Option option = AmazonRegion$.MODULE$.unapply(string);
                if (option.isEmpty()) {
                    object = S3Action$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse region ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{region})));
                } else {
                    Region r = (Region)option.get();
                    object = S3Action$.MODULE$.ok(r);
                }
                return object;
            }
        }, (Bind)Attempt.AttemptMonad$.MODULE$);
    }

    public ObjectMetadata ServerSideEncryption() {
        return (ObjectMetadata)scalaz.syntax.package$.MODULE$.id().ToIdOpsDeprecated((Object)this.DefaultObjectMetadata()).$less$bar((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ObjectMetadata x$22) {
                x$22.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            }
        });
    }

    public ObjectMetadata DefaultObjectMetadata() {
        return new ObjectMetadata();
    }

    private S3$() {
        MODULE$ = this;
        this.MultipartChunkSize = 0x500000;
    }
}

