/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.aws.dynamodb;

import argonaut.Argonaut$;
import argonaut.DecodeJson;
import argonaut.Json;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import io.atlassian.aws.dynamodb.Decoder;
import io.atlassian.aws.dynamodb.NonEmptyBytes;
import io.atlassian.aws.dynamodb.NonEmptyBytes$;
import io.atlassian.aws.dynamodb.Underlying;
import io.atlassian.aws.dynamodb.Underlying$BinaryType$;
import io.atlassian.aws.dynamodb.Underlying$NumberType$;
import io.atlassian.aws.dynamodb.Underlying$StringType$;
import io.atlassian.aws.dynamodb.package$;
import java.io.Serializable;
import java.util.UUID;
import kadai.Attempt;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scalaz.Tag$;
import scalaz.Unapply$;
import scalaz.std.list$;
import scalaz.syntax.IdOps$;
import scodec.bits.ByteVector$;

public final class Decoder$
implements scala.Serializable {
    public static Decoder$ MODULE$;
    private final Decoder<Object> LongDecode;
    private final Decoder<Object> IntDecode;
    private final Decoder<DateTime> DateTimeDecode;
    private final Decoder<Instant> InstantDecode;
    private final Decoder<Object> DynamoStringDecode;
    private final Decoder<String> StringDecode;
    private final Decoder<UUID> UUIDDecode;
    private final Decoder<NonEmptyBytes> NonEmptyBytesDecode;

    static {
        new Decoder$();
    }

    public <A> Decoder<A> apply(Decoder<A> evidence$1) {
        return (Decoder)Predef$.MODULE$.implicitly(evidence$1);
    }

    public <A> Decoder<A> decoder(Underlying.Type typ, Function1<Option<AttributeValue>, Attempt<A>> f) {
        return this.apply(f, typ);
    }

    public <A> Decoder<A> mandatoryField(Underlying.Type typ, String label, Function1<AttributeValue, A> f) {
        return this.decoder(typ, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attempt attempt;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No ", " value present"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label})));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AttributeValue av = (AttributeValue)some.value();
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().safe((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)av));
            } else {
                throw new MatchError((Object)option);
            }
            return attempt;
        });
    }

    public Decoder<Object> LongDecode() {
        return this.LongDecode;
    }

    public Decoder<Object> IntDecode() {
        return this.IntDecode;
    }

    public Decoder<DateTime> DateTimeDecode() {
        return this.DateTimeDecode;
    }

    public Decoder<Instant> InstantDecode() {
        return this.InstantDecode;
    }

    public Decoder<Object> DynamoStringDecode() {
        return this.DynamoStringDecode;
    }

    public Decoder<String> StringDecode() {
        return this.StringDecode;
    }

    public Decoder<UUID> UUIDDecode() {
        return this.UUIDDecode;
    }

    public <A, B> Decoder<Object> TaggedTypeDecode(Decoder<A> evidence$2) {
        return this.apply(evidence$2).map((Function1 & Serializable & scala.Serializable)a -> Tag$.MODULE$.apply(a));
    }

    public <A> Decoder<Option<A>> OptionDecode(Decoder<A> d) {
        return this.decoder(d.dynamoType(), (Function1 & Serializable & scala.Serializable)x0$3 -> {
            Attempt attempt;
            Option option = x0$3;
            if (option instanceof Some) {
                Some some = (Some)option;
                attempt = (Attempt)IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)d.decode((Option<AttributeValue>)some).toOption()), (Function1 & Serializable & scala.Serializable)value -> io.atlassian.aws.package$.MODULE$.Attempt().ok(value));
            } else if (None$.MODULE$.equals(option)) {
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().ok((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return attempt;
        });
    }

    public Decoder<NonEmptyBytes> NonEmptyBytesDecode() {
        return this.NonEmptyBytesDecode;
    }

    private Decoder<Json> decodeJson() {
        return this.decoder(Underlying$StringType$.MODULE$, (Function1 & Serializable & scala.Serializable)x0$5 -> {
            Attempt attempt;
            Option option = x0$5;
            if (None$.MODULE$.equals(option)) {
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().fail("No value present");
            } else if (option instanceof Some) {
                Attempt attempt2;
                Some some = (Some)option;
                AttributeValue a = (AttributeValue)some.value();
                LazyRef optBool$lzy = new LazyRef();
                LazyRef optNull$lzy = new LazyRef();
                LazyRef optNum$lzy = new LazyRef();
                LazyRef optString$lzy = new LazyRef();
                LazyRef optArray$lzy = new LazyRef();
                LazyRef optObj$lzy = new LazyRef();
                Option option2 = Decoder$.optBool$1(a, optBool$lzy).orElse((Function0 & Serializable & scala.Serializable)() -> Decoder$.optNull$1(a, optNull$lzy)).orElse((Function0 & Serializable & scala.Serializable)() -> Decoder$.optNum$1(a, optNum$lzy)).orElse((Function0 & Serializable & scala.Serializable)() -> Decoder$.optString$1(a, optString$lzy)).orElse((Function0 & Serializable & scala.Serializable)() -> this.optArray$1(a, optArray$lzy)).orElse((Function0 & Serializable & scala.Serializable)() -> this.optObj$1(a, optObj$lzy));
                if (None$.MODULE$.equals(option2)) {
                    attempt2 = io.atlassian.aws.package$.MODULE$.Attempt().fail("Could not parse JSON");
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Json j = (Json)some2.value();
                    attempt2 = io.atlassian.aws.package$.MODULE$.Attempt().ok((Object)j);
                } else {
                    throw new MatchError((Object)option2);
                }
                attempt = attempt2;
            } else {
                throw new MatchError((Object)option);
            }
            return attempt;
        });
    }

    private <A> Decoder<A> decodeJsonDirectEncoding(DecodeJson<A> evidence$3) {
        return this.decodeJson().mapAttempt((Function1 & Serializable & scala.Serializable)x$12 -> (Attempt)x$12.as(evidence$3).fold((Function2 & Serializable & scala.Serializable)(x0$7, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$7, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String msg = (String)tuple2._1();
            Attempt attempt = io.atlassian.aws.package$.MODULE$.Attempt().fail(msg);
            return attempt;
        }, (Function1 & Serializable & scala.Serializable)a -> io.atlassian.aws.package$.MODULE$.Attempt().ok(a)));
    }

    private <A> Decoder<A> decodeJsonStringEncoding(DecodeJson<A> evidence$4) {
        return this.StringDecode().mapAttempt((Function1 & Serializable & scala.Serializable)x$13 -> (Attempt)Argonaut$.MODULE$.StringToParseWrap(x$13).decodeEither(evidence$4).fold((Function1 & Serializable & scala.Serializable)message -> io.atlassian.aws.package$.MODULE$.Attempt().fail(message), (Function1 & Serializable & scala.Serializable)x$14 -> io.atlassian.aws.package$.MODULE$.Attempt().safe((Function0 & Serializable & scala.Serializable)() -> x$14)));
    }

    public <A> Decoder<A> decodeJsonDecoder(DecodeJson<A> evidence$5) {
        return this.decodeJsonDirectEncoding(evidence$5).or((Function0 & Serializable & scala.Serializable)() -> this.decodeJsonStringEncoding(evidence$5));
    }

    public <A> Decoder<A> apply(Function1<Option<AttributeValue>, Attempt<A>> run, Underlying.Type dynamoType) {
        return new Decoder<A>(run, dynamoType);
    }

    public <A> Option<Function1<Option<AttributeValue>, Attempt<A>>> unapply(Decoder<A> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.run());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$LongDecode$1(AttributeValue x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.getN())).toLong();
    }

    public static final /* synthetic */ int $anonfun$IntDecode$1(AttributeValue x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6.getN())).toInt();
    }

    public static final /* synthetic */ DateTime $anonfun$DateTimeDecode$2(long i) {
        return new DateTime(i, DateTimeZone.UTC);
    }

    private static final /* synthetic */ Option optBool$lzycompute$1(AttributeValue a$1, LazyRef optBool$lzy$1) {
        Option option;
        LazyRef lazyRef = optBool$lzy$1;
        synchronized (lazyRef) {
            option = optBool$lzy$1.initialized() ? (Option)optBool$lzy$1.value() : (Option)optBool$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getBOOL()).map((Function1 & Serializable & scala.Serializable)b -> (Json)Argonaut$.MODULE$.jBool().apply((Object)BoxesRunTime.boxToBoolean((boolean)b))));
        }
        return option;
    }

    private static final Option optBool$1(AttributeValue a$1, LazyRef optBool$lzy$1) {
        return optBool$lzy$1.initialized() ? (Option)optBool$lzy$1.value() : Decoder$.optBool$lzycompute$1(a$1, optBool$lzy$1);
    }

    private static final /* synthetic */ Option optNull$lzycompute$1(AttributeValue a$1, LazyRef optNull$lzy$1) {
        Option option;
        LazyRef lazyRef = optNull$lzy$1;
        synchronized (lazyRef) {
            option = optNull$lzy$1.initialized() ? (Option)optNull$lzy$1.value() : (Option)optNull$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getNULL()).flatMap((Function1 & Serializable & scala.Serializable)b -> Predef$.MODULE$.Boolean2boolean(b) ? new Some((Object)Argonaut$.MODULE$.jNull()) : None$.MODULE$));
        }
        return option;
    }

    private static final Option optNull$1(AttributeValue a$1, LazyRef optNull$lzy$1) {
        return optNull$lzy$1.initialized() ? (Option)optNull$lzy$1.value() : Decoder$.optNull$lzycompute$1(a$1, optNull$lzy$1);
    }

    private static final /* synthetic */ Option optNum$lzycompute$1(AttributeValue a$1, LazyRef optNum$lzy$1) {
        Option option;
        LazyRef lazyRef = optNum$lzy$1;
        synchronized (lazyRef) {
            option = optNum$lzy$1.initialized() ? (Option)optNum$lzy$1.value() : (Option)optNum$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getN()).flatMap((Function1 & Serializable & scala.Serializable)n -> Argonaut$.MODULE$.jNumber(n)));
        }
        return option;
    }

    private static final Option optNum$1(AttributeValue a$1, LazyRef optNum$lzy$1) {
        return optNum$lzy$1.initialized() ? (Option)optNum$lzy$1.value() : Decoder$.optNum$lzycompute$1(a$1, optNum$lzy$1);
    }

    private static final /* synthetic */ Option optString$lzycompute$1(AttributeValue a$1, LazyRef optString$lzy$1) {
        Option option;
        LazyRef lazyRef = optString$lzy$1;
        synchronized (lazyRef) {
            option = optString$lzy$1.initialized() ? (Option)optString$lzy$1.value() : (Option)optString$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getS()).flatMap((Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.DynamoString().syntax().DynamoStringSyntax(package$.MODULE$.DynamoString().apply((String)s)).asString()).map(Argonaut$.MODULE$.jString()));
        }
        return option;
    }

    private static final Option optString$1(AttributeValue a$1, LazyRef optString$lzy$1) {
        return optString$lzy$1.initialized() ? (Option)optString$lzy$1.value() : Decoder$.optString$lzycompute$1(a$1, optString$lzy$1);
    }

    private final /* synthetic */ Option optArray$lzycompute$1(AttributeValue a$1, LazyRef optArray$lzy$1) {
        Option option;
        LazyRef lazyRef = optArray$lzy$1;
        synchronized (lazyRef) {
            option = optArray$lzy$1.initialized() ? (Option)optArray$lzy$1.value() : (Option)optArray$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getL()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> ((Attempt)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$10).asScala()).toList(), list$.MODULE$.listInstance()).traverseU((Function1 & Serializable & scala.Serializable)av -> this.decodeJson().decode((Option<AttributeValue>)new Some(av)), Unapply$.MODULE$.unapplyMA((Object)Attempt.AttemptMonad$.MODULE$))).map((Function1 & Serializable & scala.Serializable)lj -> (Json)Argonaut$.MODULE$.jArray().apply(lj)).toOption()));
        }
        return option;
    }

    private final Option optArray$1(AttributeValue a$1, LazyRef optArray$lzy$1) {
        return optArray$lzy$1.initialized() ? (Option)optArray$lzy$1.value() : this.optArray$lzycompute$1(a$1, optArray$lzy$1);
    }

    private final /* synthetic */ Option optObj$lzycompute$1(AttributeValue a$1, LazyRef optObj$lzy$1) {
        Option option;
        LazyRef lazyRef = optObj$lzy$1;
        synchronized (lazyRef) {
            option = optObj$lzy$1.initialized() ? (Option)optObj$lzy$1.value() : (Option)optObj$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)a$1.getM()).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> ((Attempt)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$11).asScala()).toList(), list$.MODULE$.listInstance()).traverseU((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String f = (String)tuple2._1();
                AttributeValue av = (AttributeValue)tuple2._2();
                Attempt attempt = this.decodeJson().decode((Option<AttributeValue>)new Some((Object)av)).map((Function1 & Serializable & scala.Serializable)decoded -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), decoded));
                return attempt;
            }, Unapply$.MODULE$.unapplyMA((Object)Attempt.AttemptMonad$.MODULE$))).map((Function1 & Serializable & scala.Serializable)lj -> Argonaut$.MODULE$.jObjectFields((Seq)lj)).toOption()));
        }
        return option;
    }

    private final Option optObj$1(AttributeValue a$1, LazyRef optObj$lzy$1) {
        return optObj$lzy$1.initialized() ? (Option)optObj$lzy$1.value() : this.optObj$lzycompute$1(a$1, optObj$lzy$1);
    }

    private Decoder$() {
        MODULE$ = this;
        this.LongDecode = this.mandatoryField(Underlying$NumberType$.MODULE$, "Long", (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)Decoder$.$anonfun$LongDecode$1(x$5)));
        this.IntDecode = this.mandatoryField(Underlying$NumberType$.MODULE$, "Int", (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)Decoder$.$anonfun$IntDecode$1(x$6)));
        this.DateTimeDecode = this.mandatoryField(Underlying$StringType$.MODULE$, "DateTime", (Function1 & Serializable & scala.Serializable)x$7 -> (DateTime)IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(x$7.getN())).toLong())), (Function1 & Serializable & scala.Serializable)i -> Decoder$.$anonfun$DateTimeDecode$2(BoxesRunTime.unboxToLong((Object)i))));
        this.InstantDecode = this.apply(this.DateTimeDecode()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toInstant());
        this.DynamoStringDecode = this.decoder(Underlying$StringType$.MODULE$, (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Attempt attempt;
            Option option = x0$2;
            if (None$.MODULE$.equals(option)) {
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().fail("No string value present");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AttributeValue a = (AttributeValue)some.value();
                attempt = (Attempt)IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)a.getS()), (Function1 & Serializable & scala.Serializable)s -> s == null ? io.atlassian.aws.package$.MODULE$.Attempt().fail("No string value present") : io.atlassian.aws.package$.MODULE$.Attempt().ok(package$.MODULE$.DynamoString().apply((String)s)));
            } else {
                throw new MatchError((Object)option);
            }
            return attempt;
        });
        this.StringDecode = this.DynamoStringDecode().mapAttempt((Function1 & Serializable & scala.Serializable)x$9 -> (Attempt)package$.MODULE$.DynamoString().syntax().DynamoStringSyntax(x$9).asString().fold((Function0 & Serializable & scala.Serializable)() -> io.atlassian.aws.package$.MODULE$.Attempt().fail("No string value present"), (Function1 & Serializable & scala.Serializable)value -> io.atlassian.aws.package$.MODULE$.Attempt().ok(value)));
        this.UUIDDecode = this.apply(this.StringDecode()).mapAttempt((Function1 & Serializable & scala.Serializable)s -> io.atlassian.aws.package$.MODULE$.Attempt().safe((Function0 & Serializable & scala.Serializable)() -> UUID.fromString(s)));
        this.NonEmptyBytesDecode = this.decoder(Underlying$BinaryType$.MODULE$, (Function1 & Serializable & scala.Serializable)x0$4 -> {
            Attempt attempt;
            Option option = x0$4;
            if (None$.MODULE$.equals(option)) {
                attempt = io.atlassian.aws.package$.MODULE$.Attempt().fail("No value present");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AttributeValue a = (AttributeValue)some.value();
                attempt = (Attempt)IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)a.getB()), (Function1 & Serializable & scala.Serializable)bytes -> bytes == null ? io.atlassian.aws.package$.MODULE$.Attempt().fail("No value present") : (Attempt)NonEmptyBytes$.MODULE$.unapply(ByteVector$.MODULE$.apply(bytes)).fold((Function0 & Serializable & scala.Serializable)() -> io.atlassian.aws.package$.MODULE$.Attempt().fail("No value present"), (Function1 & Serializable & scala.Serializable)value -> io.atlassian.aws.package$.MODULE$.Attempt().ok(value)));
            } else {
                throw new MatchError((Object)option);
            }
            return attempt;
        });
    }
}

