/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.aws.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackSummary;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import io.atlassian.aws.AwsAction;
import io.atlassian.aws.MetaData;
import io.atlassian.aws.cloudformation.CFAction$;
import io.atlassian.aws.cloudformation.package$;
import io.atlassian.aws.package;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalaz.Monoid;
import scalaz.syntax.IdOps$;

public final class CloudFormation$ {
    public static CloudFormation$ MODULE$;

    static {
        new CloudFormation$();
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> createOrUpdateStackFrom(File file, Object name) {
        return this.stackExists(name).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> CloudFormation$.$anonfun$createOrUpdateStackFrom$1(file, name, BoxesRunTime.unboxToBoolean((Object)x0$1)), (Monoid)MetaData.MetaDataMonoid$.MODULE$);
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> createOrUpdateStackFrom(URL url, Object name) {
        return this.stackExists(name).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> CloudFormation$.$anonfun$createOrUpdateStackFrom$2(url, name, BoxesRunTime.unboxToBoolean((Object)x0$2)), (Monoid)MetaData.MetaDataMonoid$.MODULE$);
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> createStackFrom(File file, Object name) {
        return CFAction$.MODULE$.apply((Function1 & Serializable & scala.Serializable)client -> io.atlassian.aws.package$.MODULE$.Attempt().safe((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try (BufferedSource fileSource = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());){
                object = IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)client.createStack(new CreateStackRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name))).withTemplateBody(fileSource.mkString())).getStackId()), (Function1 & Serializable & scala.Serializable)a -> package$.MODULE$.StackOperationId().apply(a));
            }
            return object;
        }));
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> createStackFrom(URL url, Object name) {
        return CFAction$.MODULE$.withClient((Function1 & Serializable & scala.Serializable)x$1 -> IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)x$1.createStack(new CreateStackRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name))).withTemplateURL(url.toString())).getStackId()), (Function1 & Serializable & scala.Serializable)a -> package$.MODULE$.StackOperationId().apply(a)));
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> updateStackFrom(File file, Object name) {
        return CFAction$.MODULE$.apply((Function1 & Serializable & scala.Serializable)client -> io.atlassian.aws.package$.MODULE$.Attempt().safe((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try (BufferedSource fileSource = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());){
                object = IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)client.updateStack(new UpdateStackRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name))).withTemplateBody(fileSource.mkString())).getStackId()), (Function1 & Serializable & scala.Serializable)a -> package$.MODULE$.StackOperationId().apply(a));
            }
            return object;
        }));
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> updateStackFrom(URL url, Object name) {
        return CFAction$.MODULE$.withClient((Function1 & Serializable & scala.Serializable)x$2 -> IdOps$.MODULE$.$bar$greater$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)x$2.updateStack(new UpdateStackRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name))).withTemplateURL(url.toString())).getStackId()), (Function1 & Serializable & scala.Serializable)a -> package$.MODULE$.StackOperationId().apply(a)));
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, BoxedUnit> deleteStack(Object name) {
        return CFAction$.MODULE$.withClient((Function1 & Serializable & scala.Serializable)c -> {
            c.deleteStack(new DeleteStackRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name))));
            return BoxedUnit.UNIT;
        });
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Option<Stack>> describeStack(Object name) {
        return CFAction$.MODULE$.withClient((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.describeStacks(new DescribeStacksRequest().withStackName((String)package.AwsTaggedOps$.MODULE$.unwrap$extension(io.atlassian.aws.package$.MODULE$.AwsTaggedOps(name)))).getStacks()).asScala()).headOption());
    }

    public AwsAction<AmazonCloudFormationClient, MetaData, Object> stackExists(Object name) {
        return CFAction$.MODULE$.withClient((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CloudFormation$.$anonfun$stackExists$1(name, x$4)));
    }

    public static final /* synthetic */ AwsAction $anonfun$createOrUpdateStackFrom$1(File file$1, Object name$1, boolean x0$1) {
        AwsAction<AmazonCloudFormationClient, MetaData, Object> awsAction;
        boolean bl = x0$1;
        if (!bl) {
            awsAction = MODULE$.createStackFrom(file$1, name$1);
        } else if (bl) {
            awsAction = MODULE$.updateStackFrom(file$1, name$1);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return awsAction;
    }

    public static final /* synthetic */ AwsAction $anonfun$createOrUpdateStackFrom$2(URL url$3, Object name$7, boolean x0$2) {
        AwsAction<AmazonCloudFormationClient, MetaData, Object> awsAction;
        boolean bl = x0$2;
        if (!bl) {
            awsAction = MODULE$.createStackFrom(url$3, name$7);
        } else if (bl) {
            awsAction = MODULE$.updateStackFrom(url$3, name$7);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return awsAction;
    }

    public static final /* synthetic */ boolean $anonfun$stackExists$2(Object name$2, StackSummary x$5) {
        String string = x$5.getStackName();
        Object object = name$2;
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$stackExists$1(Object name$2, AmazonCloudFormationClient x$4) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$4.listStacks(new ListStacksRequest()).getStackSummaries()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CloudFormation$.$anonfun$stackExists$2(name$2, x$5)));
    }

    private CloudFormation$() {
        MODULE$ = this;
    }
}

