/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.standalone;

import io.atlasmap.standalone.AtlasMapXsrfRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.csrf.CsrfTokenRepository;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String DISABLE_FRAME_OPTIONS = "atlasmap.disable.frame.options";
    @Autowired
    private ApplicationContext context;

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.csrf().csrfTokenRepository((CsrfTokenRepository)new AtlasMapXsrfRepository());
        String disableFrameOptions = this.context.getEnvironment().getProperty(DISABLE_FRAME_OPTIONS);
        if (disableFrameOptions != null && "true".equals(disableFrameOptions)) {
            httpSecurity.headers().frameOptions().disable();
        }
    }
}

