/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.standalone;

import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.standalone.Application;
import io.atlasmap.standalone.CorsConfiguration;
import io.atlasmap.standalone.SecurityConfiguration;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
@ContextConfiguration(classes={Application.class, CorsConfiguration.class, SecurityConfiguration.class})
public class E2ETest {
    private static final Logger LOG = LoggerFactory.getLogger(E2ETest.class);
    private static final String DLDIR = System.getProperty("user.dir") + File.separator + "target";
    @LocalServerPort
    int port;
    ChromeDriver driver;

    @Before
    public void before() {
        String driverPath = System.getProperty("webdriver.chrome.driver");
        Assume.assumeTrue((driverPath != null && !driverPath.isEmpty() ? 1 : 0) != 0);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless", "--disable-gpu", "--no-sandbox", "--disable-setuid-sandbox"});
        HashMap<String, String> prefs = new HashMap<String, String>();
        prefs.put("download.default_directory", DLDIR);
        options.setExperimentalOption("prefs", prefs);
        this.driver = new ChromeDriver(options);
    }

    @After
    public void after() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    @Test
    public void test() throws Exception {
        this.driver.get("http://127.0.0.1:" + this.port);
        WebDriverWait waitForLoad = new WebDriverWait((WebDriver)this.driver, 5L);
        waitForLoad.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//article[@aria-label='Properties']")));
        WebElement atlasmapMenuBtn = this.driver.findElement(By.xpath((String)"//button[@data-testid='atlasmap-menu-button']"));
        atlasmapMenuBtn.click();
        waitForLoad.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//a[@data-testid='import-mappings-button']")));
        WebElement importBtn = this.driver.findElement(By.xpath((String)"//a[@data-testid='import-mappings-button']"));
        importBtn.click();
        WebElement fileInput = this.driver.findElement(By.xpath((String)"//div[@id='data-toolbar']//input[@type='file']"));
        String cwd = System.getProperty("user.dir");
        fileInput.sendKeys(new CharSequence[]{cwd + "/src/test/resources/json-schema-source-to-xml-schema-target.adm"});
        WebElement confirmBtn = this.driver.findElement(By.xpath((String)"//button[@data-testid='confirmation-dialog-confirm-button']"));
        confirmBtn.click();
        waitForLoad.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//article[@aria-label='JSONSchemaSource']")));
        WebElement orderBtn = this.driver.findElement(By.xpath((String)"//button[@id='sources-field-atlas:json:JSONSchemaSource:source:/order-toggle']"));
        orderBtn.click();
        WebElement addrBtn = this.driver.findElement(By.xpath((String)"//button[@id='sources-field-atlas:json:JSONSchemaSource:source:/order/address-toggle']"));
        addrBtn.click();
        WebElement addrDiv = this.driver.findElement(By.xpath((String)"//button[@id='sources-field-atlas:json:JSONSchemaSource:source:/order/address-toggle']/../.."));
        WebElement cityDiv = addrDiv.findElement(By.xpath((String)".//button[@data-testid='grip-city-button']/../../../.."));
        Actions action = new Actions((WebDriver)this.driver);
        action.moveToElement(cityDiv).perform();
        WebElement showDetailsBtn = cityDiv.findElement(By.xpath((String)".//button[@data-testid='show-mapping-details-button']"));
        showDetailsBtn.click();
        WebElement detailsCity = (WebElement)waitForLoad.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//div[@role='dialog']//div[@aria-labelledby='mapping-field-city']")));
        Assert.assertNotNull((Object)detailsCity);
        WebElement customActionParamInput = this.driver.findElement(By.id((String)"user-field-action-io.atlasmap.service.my.MyFieldActionsModel-transformation-0"));
        Assert.assertEquals((Object)"testparam", (Object)customActionParamInput.getAttribute("value"));
        WebElement customClassDoc = this.driver.findElement(By.xpath((String)"//article[@aria-label='io.atlasmap.service.my.MyFieldActionsModel']"));
        WebElement paramDiv = customClassDoc.findElement(By.xpath((String)".//button[@data-testid='grip-param-button']/../../../.."));
        action = new Actions((WebDriver)this.driver);
        action.moveToElement(paramDiv).perform();
        showDetailsBtn = paramDiv.findElement(By.xpath((String)".//button[@data-testid='show-mapping-details-button']"));
        showDetailsBtn.click();
        WebElement detailsPhotoUrl = (WebElement)waitForLoad.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//div[@data-testid='column-mapping-details-area']//div[@data-testid='mapping-fields-detail-Targets-toggle']//div[@data-testid='mapping-field-photoUrl']")));
        Assert.assertNotNull((Object)detailsPhotoUrl);
        atlasmapMenuBtn = this.driver.findElement(By.xpath((String)"//button[@data-testid='atlasmap-menu-button']"));
        atlasmapMenuBtn.click();
        waitForLoad.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//a[@data-testid='export-mappings-button']")));
        WebElement exportBtn = this.driver.findElement(By.xpath((String)"//a[@data-testid='export-mappings-button']"));
        exportBtn.click();
        WebElement dialogDiv = this.driver.findElement(By.xpath((String)"//div[@role='dialog' and @aria-label='Export Mappings and Documents.']"));
        WebElement exportInput = dialogDiv.findElement(By.id((String)"filename"));
        String exportAdmFileName = UUID.randomUUID().toString() + "-exported.adm";
        exportInput.clear();
        exportInput.sendKeys(new CharSequence[]{exportAdmFileName});
        confirmBtn = dialogDiv.findElement(By.xpath((String)".//button[@data-testid='confirmation-dialog-confirm-button']"));
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path dirPath = Paths.get(DLDIR, new String[0]);
        dirPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        confirmBtn.click();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 300000L) {
            WatchKey key = watcher.poll(5L, TimeUnit.SECONDS);
            if (key == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!StandardWatchEventKinds.ENTRY_CREATE.name().equals(event.kind().name())) continue;
                Path eventPath = (Path)event.context();
                LOG.info("File '{}' is created", (Object)eventPath.getFileName().toString());
                if (!exportAdmFileName.equals(eventPath.getFileName().toString())) continue;
                ADMArchiveHandler handler = new ADMArchiveHandler(this.getClass().getClassLoader());
                handler.setLibraryDirectory(Paths.get(DLDIR + File.separator + "lib", new String[0]));
                handler.load(Paths.get(DLDIR + File.separator + exportAdmFileName, new String[0]));
                Assert.assertEquals((Object)"UI.0", (Object)handler.getMappingDefinition().getName());
                return;
            }
        }
        Assert.fail((String)"exported.adm was not created");
    }
}

