/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.standalone;

import io.atlasmap.standalone.Application;
import io.atlasmap.standalone.CorsConfiguration;
import io.atlasmap.standalone.SecurityConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
@ContextConfiguration(classes={Application.class, CorsConfiguration.class, SecurityConfiguration.class})
public class RestTest {
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    @LocalServerPort
    int port;

    @Test
    public void getFieldActions() throws IOException {
        Request request = new Request.Builder().url("http://127.0.0.1:" + this.port + "/v2/atlas/fieldActions").header("ATLASMAP-XSRF-TOKEN", "awesome").build();
        try (Response response = CLIENT.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            System.out.println(response.body().string());
        }
    }

    @Test
    public void testJsonInspect() throws IOException {
        Request request = new Request.Builder().url("http://127.0.0.1:" + this.port + "/v2/atlas/json/inspect").header("ATLASMAP-XSRF-TOKEN", "awesome").post(RequestBody.create((String)RestTest.resource("atlasmap-json-inspection.json"), (MediaType)APPLICATION_JSON)).build();
        try (Response response = CLIENT.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            System.out.println(response.body().string());
        }
    }

    @Test
    public void testJsonInspectWithoutXsrfProtectionToken() throws Exception {
        Request request = new Request.Builder().url("http://127.0.0.1:" + this.port + "/v2/atlas/json/inspect").post(RequestBody.create((String)RestTest.resource("atlasmap-json-inspection.json"), (MediaType)APPLICATION_JSON)).build();
        try (Response response = CLIENT.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isFalse();
            System.out.println(response.body().string());
        }
    }

    protected static String resource(String file) throws IOException {
        try (InputStream is = RestTest.class.getClassLoader().getResourceAsStream(file);){
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RestTest.copy(is, os);
            String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    protected static void copy(InputStream is, ByteArrayOutputStream os) throws IOException {
        int c;
        while ((c = is.read()) >= 0) {
            os.write(c);
        }
    }
}

