/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.standalone;

import io.atlasmap.standalone.Application;
import io.atlasmap.standalone.CorsConfiguration;
import io.atlasmap.standalone.SecurityConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
@ContextConfiguration(classes={Application.class, CorsConfiguration.class, SecurityConfiguration.class})
public class E2ETest {
    @LocalServerPort
    int port;
    ChromeDriver driver;

    @Before
    public void before() {
        String driverPath = System.getProperty("webdriver.chrome.driver");
        Assume.assumeTrue((driverPath != null && !driverPath.isEmpty() ? 1 : 0) != 0);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless", "--disable-gpu", "--no-sandbox", "--disable-setuid-sandbox"});
        this.driver = new ChromeDriver(options);
    }

    @After
    public void after() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    @Test
    public void testEmpty() throws IOException {
        this.driver.get("http://127.0.0.1:" + this.port);
        WebDriverWait waitForLoad = new WebDriverWait((WebDriver)this.driver, 5L);
        waitForLoad.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"Properties")));
        WebElement container = this.driver.findElement(By.tagName((String)"data-mapper-error"));
        List errors = container.findElements(By.className((String)"alert-danger"));
        Assert.assertEquals((String)("Some error message was found: " + container.getAttribute("innerHTML")), (long)0L, (long)errors.size());
    }
}

