/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.maven;

import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.maven.AbstractAtlasMapMojo;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-inspections")
public class GenerateInspectionsMojo
extends AbstractAtlasMapMojo {
    public static final String DEFAULT_OUTPUT_FILE_PREFIX = "atlasmap-inspection";
    @Parameter
    private List<String> artifacts;
    @Parameter(property="className")
    private String className;
    @Parameter(property="collectionType")
    private String collectionType;
    @Parameter(property="collectionClassName")
    private String collectionClassName;
    @Parameter
    private List<Inspection> inspections;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getOutputDir() != null) {
            this.getOutputDir().mkdirs();
        }
        CollectionType collectionType = CollectionType.NONE;
        if (this.collectionType != null) {
            collectionType = CollectionType.valueOf((String)this.collectionType);
        }
        if (this.artifacts != null && this.className != null) {
            this.generateJavaInspection(this.artifacts, Arrays.asList(this.className), collectionType, this.collectionClassName);
        }
        if (this.inspections != null) {
            for (Inspection inspection : this.inspections) {
                ArrayList<String> classNames = new ArrayList<String>();
                if (inspection.classNames != null) {
                    classNames.addAll(inspection.classNames);
                } else if (inspection.className != null) {
                    classNames.add(inspection.className);
                } else {
                    this.generateFileInspection(inspection);
                }
                collectionType = CollectionType.NONE;
                if (inspection.collectionType != null) {
                    collectionType = CollectionType.valueOf((String)inspection.collectionType);
                }
                this.generateJavaInspection(inspection.artifacts, classNames, collectionType, inspection.collectionClassName);
            }
        }
    }

    private void generateJavaInspection(List<String> artifacts, Collection<String> classNames, CollectionType collectionType, String collectionClassName) throws MojoFailureException, MojoExecutionException {
        List<URL> urls = artifacts == null ? Collections.emptyList() : this.resolveClasspath(artifacts);
        ClassLoader origTccl = Thread.currentThread().getContextClassLoader();
        for (String className : classNames) {
            Class<?> clazz = null;
            JavaClass c = null;
            try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), origTccl);){
                clazz = loader.loadClass(className);
                ClassInspectionService classInspectionService = new ClassInspectionService();
                classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
                c = classInspectionService.inspectClass((ClassLoader)loader, clazz, collectionType, collectionClassName);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            this.writeToJsonFile("atlasmap-inspection-" + className, c);
        }
    }

    private void generateFileInspection(Inspection inspection) throws MojoFailureException {
        File file = new File(inspection.fileName);
        if (!file.exists()) {
            this.getLog().warn((CharSequence)String.format("Ignoring '%s'", inspection.fileName));
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (!child.exists() || child.isDirectory()) {
                    this.getLog().warn((CharSequence)String.format("Ignoring '%s'", child.getAbsolutePath()));
                    continue;
                }
                if (child.getName().toLowerCase().endsWith(".json")) {
                    if (inspection.inspectionType == InspectionType.INSTANCE) {
                        this.generateJsonInstanceInspection(child.getAbsolutePath());
                        continue;
                    }
                    this.generateJsonSchemaInspection(child.getAbsolutePath());
                    continue;
                }
                if (child.getName().toLowerCase().endsWith(".xsd")) {
                    this.generateXmlSchemaInspection(child.getAbsolutePath());
                    continue;
                }
                if (child.getName().toLowerCase().endsWith(".xml")) {
                    if (inspection.inspectionType == InspectionType.SCHEMA) {
                        this.generateXmlSchemaInspection(child.getAbsolutePath());
                        continue;
                    }
                    this.generateXmlInstanceInspection(child.getAbsolutePath());
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Ignoring unsupported file type '%s'", child.getAbsolutePath()));
            }
            return;
        }
        if (file.getName().toLowerCase().endsWith(".json")) {
            if (inspection.inspectionType == InspectionType.INSTANCE) {
                this.generateJsonInstanceInspection(file.getAbsolutePath());
            } else {
                this.generateJsonSchemaInspection(file.getAbsolutePath());
            }
        } else if (file.getName().toLowerCase().endsWith(".xsd")) {
            this.generateXmlSchemaInspection(file.getAbsolutePath());
        } else if (file.getName().toLowerCase().endsWith(".xml")) {
            if (inspection.inspectionType == InspectionType.SCHEMA) {
                this.generateXmlSchemaInspection(file.getAbsolutePath());
            } else {
                this.generateXmlInstanceInspection(file.getAbsolutePath());
            }
        } else {
            throw new MojoFailureException(String.format("Inspection type '%s' is not supported", inspection.getClass().getName()));
        }
    }

    private void generateJsonSchemaInspection(String fileName) throws MojoFailureException {
        try {
            Path path = Paths.get(fileName, new String[0]);
            String schema = new String(Files.readAllBytes(path));
            JsonDocument d = new JsonInspectionService().inspectJsonSchema(schema);
            String name = path.getFileName().toString();
            String outputName = name.substring(0, name.length() - 5);
            this.writeToJsonFile("atlasmap-inspection-" + outputName, d);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateJsonInstanceInspection(String fileName) throws MojoFailureException {
        try {
            Path path = Paths.get(fileName, new String[0]);
            String schema = new String(Files.readAllBytes(path));
            JsonDocument d = new JsonInspectionService().inspectJsonDocument(schema);
            String name = path.getFileName().toString();
            String outputName = name.substring(0, name.length() - 5);
            this.writeToJsonFile("atlasmap-inspection-" + outputName, d);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateXmlSchemaInspection(String fileName) throws MojoFailureException {
        try {
            File f = new File(fileName);
            XmlDocument d = new XmlInspectionService().inspectSchema(f);
            String outputName = f.getName().substring(0, f.getName().length() - 4);
            this.writeToJsonFile("atlasmap-inspection-" + outputName, d);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateXmlInstanceInspection(String fileName) throws MojoFailureException {
        try {
            File f = new File(fileName);
            XmlDocument d = new XmlInspectionService().inspectXmlDocument(f);
            String outputName = f.getName().substring(0, f.getName().length() - 4);
            this.writeToJsonFile("atlasmap-inspection-" + outputName, d);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public void setInspections(List<Inspection> inspections) {
        this.inspections = inspections;
    }

    public static class Inspection {
        private List<String> artifacts;
        private String className;
        private String collectionType;
        private String collectionClassName;
        private List<String> classNames;
        private String fileName;
        private InspectionType inspectionType;

        public String getClassName() {
            return this.className;
        }

        public List<String> getClassNames() {
            return this.classNames;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassNames(List<String> classNames) {
            this.classNames = classNames;
        }

        public String getCollectionType() {
            return this.collectionType;
        }

        public void setCollectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        public String getCollectionClassName() {
            return this.collectionClassName;
        }

        public void setCollectionClassName(String collectionClassName) {
            this.collectionClassName = collectionClassName;
        }

        public List<String> getArtifacts() {
            return this.artifacts;
        }

        public void setArtifacts(List<String> artifacts) {
            this.artifacts = artifacts;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public InspectionType getInspectionType() {
            return this.inspectionType;
        }

        public void setInspectionType(InspectionType inspectionType) {
            this.inspectionType = inspectionType;
        }
    }

    public static enum InspectionType {
        SCHEMA,
        INSTANCE;

    }
}

