/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.maven;

import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.maven.AbstractAtlasMapMojo;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.v2.ActionDetails;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-field-actions")
public class GenerateFieldActionsMojo
extends AbstractAtlasMapMojo {
    public static final String DEFAULT_OUTPUT_FILE_PREFIX = "atlasmap-field-action";
    @Parameter
    private List<String> artifacts;
    @Parameter
    private List<String> jars;
    @Parameter
    private List<FieldAction> fieldActions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getOutputDir() != null) {
            this.getOutputDir().mkdirs();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.artifacts != null) {
            urls.addAll(this.resolveClasspath(this.artifacts));
        }
        if (this.jars != null) {
            for (String jar : this.jars) {
                File jarFile;
                if (jar == null || jar.isEmpty() || !(jarFile = new File(jar)).exists()) {
                    this.getLog().warn((CharSequence)String.format("Could not load jar file '%s' - ignoring", jar));
                    continue;
                }
                try {
                    urls.add(jarFile.toURI().toURL());
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)String.format("Could not load jar file '%s' - ignoring", jar), (Throwable)e);
                }
            }
        }
        if (this.fieldActions != null) {
            for (FieldAction fieldAction : this.fieldActions) {
                if (fieldAction.artifacts != null) {
                    urls.addAll(this.resolveClasspath(fieldAction.artifacts));
                }
                if (fieldAction.jars == null) continue;
                for (String jar : fieldAction.jars) {
                    File jarFile;
                    if (jar == null || jar.isEmpty() || !(jarFile = new File(jar)).exists()) {
                        this.getLog().warn((CharSequence)String.format("Could not load jar file '%s' - ignoring", jar));
                        continue;
                    }
                    try {
                        urls.add(jarFile.toURI().toURL());
                    }
                    catch (Exception e) {
                        this.getLog().warn((CharSequence)String.format("Could not load jar file '%s' - ignoring", jar), (Throwable)e);
                    }
                }
            }
        }
        if (!urls.isEmpty()) {
            this.generateFieldAction(urls);
        }
    }

    private void generateFieldAction(List<URL> urls) throws MojoFailureException, MojoExecutionException {
        DefaultAtlasFieldActionService fieldActionService = new DefaultAtlasFieldActionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        ClassLoader origTccl = Thread.currentThread().getContextClassLoader();
        ActionDetails answer = new ActionDetails();
        try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), origTccl);){
            fieldActionService.init((ClassLoader)loader);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not load field actions:", e);
        }
        answer.getActionDetail().addAll(fieldActionService.listActionDetails());
        this.writeToJsonFile(DEFAULT_OUTPUT_FILE_PREFIX, answer);
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public List<FieldAction> getFieldActions() {
        return this.fieldActions;
    }

    public void setFieldActions(List<FieldAction> fieldActions) {
        this.fieldActions = fieldActions;
    }

    public static class FieldAction {
        private List<String> artifacts;
        private List<String> jars;

        public List<String> getArtifacts() {
            return this.artifacts;
        }

        public void setArtifacts(List<String> artifacts) {
            this.artifacts = artifacts;
        }

        public List<String> getJars() {
            return this.jars;
        }

        public void setJars(List<String> jars) {
            this.jars = jars;
        }

        public String toString() {
            return "{artifacts:" + this.artifacts + ", jars:" + this.jars + "}";
        }
    }
}

