/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.service.AtlasJsonProvider;
import io.atlasmap.java.v2.JavaClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate-inspections")
public class GenerateInspectionsMojo
extends AbstractMojo {
    @Component
    private RepositorySystem system;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/atlasmap")
    private File outputDir;
    @Parameter
    private File outputFile;
    @Parameter(property="gav")
    private String gav;
    @Parameter(property="className")
    private String className;
    @Parameter
    private List<Inspection> inspections;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDir != null) {
            this.outputDir.mkdirs();
        }
        if (this.gav != null && this.className != null) {
            this.generateInspection(this.gav, Arrays.asList(this.className));
        }
        if (this.inspections != null) {
            for (Inspection inspection : this.inspections) {
                ArrayList<String> classNames = new ArrayList<String>(inspection.classNames);
                if (inspection.className != null) {
                    classNames.add(inspection.className);
                }
                this.generateInspection(inspection.gav, classNames);
            }
        }
    }

    private void generateInspection(String gav, Collection<String> classNames) throws MojoFailureException, MojoExecutionException {
        URL[] urls = this.resolveClasspath(gav);
        for (String className : classNames) {
            Class<?> clazz = null;
            try {
                URLClassLoader loader = new URLClassLoader(urls, null);
                clazz = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            ClassInspectionService classInspectionService = new ClassInspectionService();
            classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
            JavaClass c = classInspectionService.inspectClass(clazz);
            try {
                ObjectMapper objectMapper = AtlasJsonProvider.createObjectMapper();
                File target = this.outputFile;
                if (target == null) {
                    target = new File(this.outputDir, "atlasmap-inpection-" + className + ".json");
                }
                objectMapper.writeValue(target, (Object)c);
                this.getLog().info((CharSequence)("Created: " + target));
            }
            catch (JsonProcessingException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private URL[] resolveClasspath(String mavenGav) throws MojoFailureException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(mavenGav);
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
            collectRequest.setRepositories(this.remoteRepos);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.system.resolveDependencies(this.repoSession, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            dependencyResult.getRoot().accept((DependencyVisitor)nlg);
            Iterator it = nlg.getNodes().iterator();
            ArrayList<URL> urls = new ArrayList<URL>();
            while (it.hasNext()) {
                Artifact x;
                DependencyNode node = (DependencyNode)it.next();
                if (node.getDependency() == null || (x = node.getDependency().getArtifact()).getFile() == null) continue;
                urls.add(x.getFile().toURI().toURL());
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public void setSystem(RepositorySystem system) {
        this.system = system;
    }

    public List<RemoteRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    public void setRemoteRepos(List<RemoteRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
    }

    public RepositorySystemSession getRepoSession() {
        return this.repoSession;
    }

    public void setRepoSession(RepositorySystemSession repoSession) {
        this.repoSession = repoSession;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public String getGav() {
        return this.gav;
    }

    public void setGav(String gav) {
        this.gav = gav;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public void setInspections(List<Inspection> inspections) {
        this.inspections = inspections;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Inspection {
        private String gav;
        private String className;
        private List<String> classNames;

        public String getGav() {
            return this.gav;
        }

        public String getClassName() {
            return this.className;
        }

        public List<String> getClassNames() {
            return this.classNames;
        }

        public void setGav(String gav) {
            this.gav = gav;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassNames(List<String> classNames) {
            this.classNames = classNames;
        }
    }
}

