/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.kafka.smt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import net.mguenther.kafka.junit.EmbeddedConnectConfig;
import net.mguenther.kafka.junit.EmbeddedKafkaCluster;
import net.mguenther.kafka.junit.EmbeddedKafkaClusterConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public class AtlasMapSMTTest {
    private EmbeddedKafkaCluster kafka;

    @BeforeEach
    void before() {
        Properties source = new Properties();
        source.put("name", "source-connector");
        source.put("connector.class", "FileStreamSource");
        source.put("file", "src/test/resources/source.json");
        source.put("topic", "topic");
        source.put("topics", "topic");
        source.put("tasks.max", (Object)1);
        source.put("transforms", "atlasmap");
        source.put("transforms.atlasmap.type", "io.atlasmap.kafka.smt.AtlasMapSMT");
        source.put("transforms.atlasmap.adm.path", "src/test/resources/atlasmap-mapping.adm");
        source.put("transforms.atlasmap.docid.source.value", "source-c7ee0c6f-d615-4d53-9563-d91750745cf9");
        source.put("transforms.atlasmap.docid.target.value", "target-4e4d7eb5-8dff-4de8-9780-0707a07a9bad");
        Properties sink = new Properties();
        sink.put("name", "sink-connector-value");
        sink.put("connector.class", "FileStreamSink");
        sink.put("file", "target/target.xml");
        sink.put("topic", "topic");
        sink.put("topics", "topic");
        sink.put("tasks.max", (Object)1);
        EmbeddedConnectConfig.EmbeddedConnectConfigBuilder connect = EmbeddedConnectConfig.kafkaConnect().deployConnector(source).deployConnector(sink);
        EmbeddedKafkaClusterConfig.EmbeddedKafkaClusterConfigBuilder cluster = EmbeddedKafkaClusterConfig.newClusterConfig().configure(connect);
        this.kafka = EmbeddedKafkaCluster.provisionWith((EmbeddedKafkaClusterConfig.EmbeddedKafkaClusterConfigBuilder)cluster);
        this.kafka.start();
    }

    @AfterEach
    void after() {
        this.kafka.stop();
    }

    @Test
    public void test() throws Exception {
        File f = new File("target/target.xml");
        for (int i = 0; !f.exists() && i < 5; ++i) {
            Thread.sleep(1000L);
            f = new File("target/target.xml");
        }
        Assertions.assertTrue((boolean)f.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String line = reader.readLine();
            for (int i = 0; line == null && i < 5; ++i) {
                Thread.sleep(1000L);
                line = reader.readLine();
            }
            Assertions.assertNotNull((Object)line);
            Diff d = DiffBuilder.compare((Object)Input.fromFile((String)"src/test/resources/target.xml").build()).withTest((Object)Input.fromString((String)line).build()).ignoreWhitespace().build();
            Assertions.assertFalse((boolean)d.hasDifferences(), (String)(d.toString() + ": " + line));
        }
    }
}

