/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.kafka.smt;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import java.io.File;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMapSMT<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Process AtlasMap data mapping with a Kafka Connect record";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("adm.path", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Path for the ADM file").define("docid.source.key", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Document ID for the source key").define("docid.source.value", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Document ID for the source value").define("docid.target.key", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Document ID for the target key").define("docid.target.value", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Document ID for the target value");
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapSMT.class);
    private String admPath;
    private String docIdSourceKey;
    private String docIdSourceValue;
    private String docIdTargetKey;
    private String docIdTargetValue;
    private DefaultAtlasContext atlasContext;

    public void configure(Map<String, ?> props) {
        block2: {
            SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
            this.admPath = config.getString("adm.path");
            this.docIdSourceKey = config.getString("docid.source.key");
            this.docIdSourceValue = config.getString("docid.source.value");
            this.docIdTargetKey = config.getString("docid.target.key");
            this.docIdTargetValue = config.getString("docid.target.value");
            try {
                this.atlasContext = DefaultAtlasContextFactory.getInstance().createContext(new File(this.admPath));
            }
            catch (Exception e) {
                LOG.error("Could not load ADM archive file: {}", (Object)e.getMessage());
                if (!LOG.isDebugEnabled()) break block2;
                LOG.error("", (Throwable)e);
            }
        }
    }

    public R apply(R record) {
        try {
            AtlasSession session = this.atlasContext.createSession();
            if (this.docIdSourceKey != null && !this.docIdSourceKey.isEmpty()) {
                session.setSourceDocument(this.docIdSourceKey, record.key());
            }
            if (this.docIdSourceValue != null && !this.docIdSourceValue.isEmpty()) {
                session.setSourceDocument(this.docIdSourceValue, record.value());
            } else {
                session.setDefaultSourceDocument(record.value());
            }
            this.atlasContext.process(session);
            Object outKey = null;
            Object outValue = null;
            if (this.docIdTargetKey != null && !this.docIdTargetKey.isEmpty()) {
                outKey = session.getTargetDocument(this.docIdTargetKey);
            }
            outValue = this.docIdTargetValue != null && !this.docIdTargetValue.isEmpty() ? session.getTargetDocument(this.docIdTargetValue) : session.getDefaultTargetDocument();
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), null, outKey, null, outValue, record.timestamp());
        }
        catch (Exception e) {
            LOG.error("Could not process AtlasMap mapping: {}", (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return record;
        }
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    private static interface ConfigName {
        public static final String ADM_PATH = "adm.path";
        public static final String DOCID_SOURCE_KEY = "docid.source.key";
        public static final String DOCID_SOURCE_VALUE = "docid.source.value";
        public static final String DOCID_TARGET_KEY = "docid.target.key";
        public static final String DOCID_TARGET_VALUE = "docid.target.value";
    }
}

