/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.v2.JsonInspectionRequest;
import io.atlasmap.json.v2.JsonInspectionResponse;
import io.atlasmap.v2.Json;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/json/")
public class JsonService {
    private static final Logger LOG = LoggerFactory.getLogger(JsonService.class);

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    @Operation(summary="Simple", description="Simple hello service")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=String.class))}, description="Return a response")})
    public String simpleHelloWorld(@Parameter(description="From") @QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @POST
    @Path(value="/inspect")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Inspect JSON", description="Inspect a JSON schema or instance and return a Document object")
    @RequestBody(description="JsonInspectionRequest object", content={@Content(schema=@Schema(implementation=JsonInspectionRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=JsonInspectionResponse.class))}, description="Return a Document object represented by JsonDocument")})
    public Response inspect(InputStream requestIn) {
        block11: {
            request = this.fromJson(requestIn, JsonInspectionRequest.class);
            startTime = System.currentTimeMillis();
            response = new JsonInspectionResponse();
            d = null;
            try {
                if (request.getType() == null || request.getJsonData() == null) {
                    response.setErrorMessage("Json data and Instance or Schema inspection type must be specified in request");
                    break block11;
                }
                s = new JsonInspectionService();
                jsonData = this.cleanJsonData(request.getJsonData());
                if (!this.validJsonData(jsonData)) {
                    response.setErrorMessage("Invalid json payload specified");
                    break block11;
                }
                switch (1.$SwitchMap$io$atlasmap$json$v2$InspectionType[request.getType().ordinal()]) {
                    case 1: {
                        d = s.inspectJsonDocument(jsonData);
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        d = s.inspectJsonSchema(jsonData);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    default: {
                        response.setErrorMessage("Unsupported inspection type: " + request.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                JsonService.LOG.error("Error inspecting json: " + e.getMessage(), (Throwable)e);
                response.setErrorMessage(e.getMessage());
            }
            finally {
                response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            }
        }
        AtlasUtil.excludeNotRequestedFields(d, (List)request.getInspectPaths());
        response.setJsonDocument(d);
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    protected boolean validJsonData(String jsonData) {
        if (jsonData == null || jsonData.isEmpty()) {
            return false;
        }
        return jsonData.startsWith("{") || jsonData.startsWith("[");
    }

    protected String cleanJsonData(String jsonData) {
        return jsonData.trim();
    }
}

