/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.service;

import io.atlasmap.json.service.JsonService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonServiceTest {
    private JsonService jsonService = null;

    @BeforeEach
    public void setUp() {
        this.jsonService = new JsonService();
    }

    @AfterEach
    public void tearDown() {
        this.jsonService = null;
    }

    @Test
    public void testValidJsonData() {
        Assertions.assertTrue((boolean)this.jsonService.validJsonData("{ \"foo\":\"bar\" }"));
        Assertions.assertTrue((boolean)this.jsonService.validJsonData("[ { \"foo\":\"bar\" }, { \"meow\":\"blah\" } ]"));
        Assertions.assertFalse((boolean)this.jsonService.validJsonData("  [ { \"foo\":\"bar\" }, { \"meow\":\"blah\" } ]"));
        Assertions.assertFalse((boolean)this.jsonService.validJsonData("  \"foo\":\"bar\" }, { \"meow\":\"blah\" } ]"));
        Assertions.assertTrue((boolean)this.jsonService.validJsonData(this.jsonService.cleanJsonData("  { \"foo\":\"bar\" }")));
        Assertions.assertTrue((boolean)this.jsonService.validJsonData(this.jsonService.cleanJsonData("{ \"foo\":\"bar\" }   ")));
        Assertions.assertTrue((boolean)this.jsonService.validJsonData(this.jsonService.cleanJsonData("  [ { \"foo\":\"bar\" }, { \"meow\":\"blah\" } ]")));
        Assertions.assertTrue((boolean)this.jsonService.validJsonData(this.jsonService.cleanJsonData("\b\t\n\f\r   { \"foo\":\"bar\" }")));
    }
}

