/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.json.inspect.JsonDocumentInspectionService;
import io.atlasmap.json.v2.InspectionType;
import io.atlasmap.json.v2.JsonInspectionRequest;
import io.atlasmap.json.v2.JsonInspectionResponse;
import io.atlasmap.v2.Json;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas/json")
public class JsonService {
    private static final Logger LOG = LoggerFactory.getLogger(JsonService.class);

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @GET
    @Path(value="/inspect")
    @Produces(value={"application/json"})
    public Response getClass(@QueryParam(value="uri") String uri, @QueryParam(value="type") String type) {
        Object d = null;
        try {
            if (type == null) {
                throw new Exception("uri and type parameters must be specified");
            }
            InspectionType inspectType = InspectionType.valueOf((String)type);
            switch (inspectType) {
                default: 
            }
            throw new Exception("Unknown type specified: " + type);
        }
        catch (Exception e) {
            LOG.error("Error inspecting xml: " + e.getMessage(), (Throwable)e);
            return Response.ok().entity((Object)this.toJson(d)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/inspect")
    public Response inspectClass(InputStream requestIn) {
        block11: {
            request = this.fromJson(requestIn, JsonInspectionRequest.class);
            startTime = System.currentTimeMillis();
            response = new JsonInspectionResponse();
            d = null;
            try {
                if (request.getType() == null || request.getJsonData() == null) {
                    response.setErrorMessage("Json data and Instance or Schema inspection type must be specified in request");
                    break block11;
                }
                s = new JsonDocumentInspectionService();
                jsonData = this.cleanJsonData(request.getJsonData());
                if (!this.validJsonData(jsonData)) {
                    response.setErrorMessage("Invalid json payload specified");
                    break block11;
                }
                switch (1.$SwitchMap$io$atlasmap$json$v2$InspectionType[request.getType().ordinal()]) {
                    case 1: {
                        d = s.inspectJsonDocument(jsonData);
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        d = s.inspectJsonSchema(jsonData);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    default: {
                        response.setErrorMessage("Unsupported inspection type: " + request.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                JsonService.LOG.error("Error inspecting json: " + e.getMessage(), (Throwable)e);
                response.setErrorMessage(e.getMessage());
            }
            finally {
                response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            }
        }
        response.setJsonDocument(d);
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    protected boolean validJsonData(String jsonData) {
        if (jsonData == null || jsonData.isEmpty()) {
            return false;
        }
        return jsonData.startsWith("{") || jsonData.startsWith("[");
    }

    protected String cleanJsonData(String jsonData) {
        return jsonData.trim();
    }
}

