/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.service;

import io.atlasmap.json.inspect.JsonDocumentInspectionService;
import io.atlasmap.json.v2.InspectionType;
import io.atlasmap.json.v2.JsonInspectionRequest;
import io.atlasmap.json.v2.JsonInspectionResponse;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas/json")
public class JsonService
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(JsonService.class);

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @OPTIONS
    @Path(value="/inspect")
    @Produces(value={"application/json"})
    public Response testJsonOptions() throws Exception {
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/inspect")
    @Produces(value={"application/json"})
    public Response getClass(@QueryParam(value="uri") String uri, @QueryParam(value="type") String type) throws Exception {
        long startTime = System.currentTimeMillis();
        Object d = null;
        try {
            try {
                if (type == null) {
                    throw new Exception("uri and type parameters must be specified");
                }
                InspectionType inspectType = InspectionType.valueOf((String)type);
                JsonDocumentInspectionService s = new JsonDocumentInspectionService();
                switch (inspectType) {
                    default: 
                }
                throw new Exception("Unknown type specified: " + type);
            }
            catch (Exception e) {
                logger.error("Error inspecting xml: " + e.getMessage(), (Throwable)e);
                long endTime = System.currentTimeMillis() - startTime;
            }
        }
        catch (Throwable throwable) {
            long endTime = System.currentTimeMillis() - startTime;
            throw throwable;
        }
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").entity(d).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/inspect")
    public Response inspectClass(JsonInspectionRequest request) throws Exception {
        block11: {
            startTime = System.currentTimeMillis();
            response = new JsonInspectionResponse();
            d = null;
            try {
                if (request.getType() == null || request.getJsonData() == null) {
                    response.setErrorMessage("Json data and Instance or Schema inspection type must be specified in request");
                    break block11;
                }
                s = new JsonDocumentInspectionService();
                jsonData = this.cleanJsonData(request.getJsonData());
                if (!this.validJsonData(jsonData)) {
                    response.setErrorMessage("Invalid json payload specified");
                    break block11;
                }
                switch (1.$SwitchMap$io$atlasmap$json$v2$InspectionType[request.getType().ordinal()]) {
                    case 1: {
                        d = s.inspectJsonDocument(jsonData);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        d = s.inspectJsonSchema(jsonData);
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    default: {
                        response.setErrorMessage("Unsupported inspection type: " + request.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                JsonService.logger.error("Error inspecting json: " + e.getMessage(), (Throwable)e);
                response.setErrorMessage(e.getMessage());
            }
            finally {
                response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            }
        }
        response.setJsonDocument(d);
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").entity((Object)response).build();
    }

    protected boolean validJsonData(String jsonData) {
        if (jsonData == null || jsonData.isEmpty()) {
            return false;
        }
        return jsonData.startsWith("{") || jsonData.startsWith("[");
    }

    protected String cleanJsonData(String jsonData) {
        return jsonData.trim();
    }
}

