/**
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.atlasmap.java.test;

import java.util.Arrays;

public abstract class BaseFlatPrimitiveClass {

    protected int intField;
    protected short shortField;
    protected long longField;
    protected double doubleField;
    protected float floatField;
    protected boolean booleanField;
    protected char charField;
    protected byte byteField;
    protected Boolean boxedBooleanField;
    protected Byte boxedByteField;
    protected Character boxedCharField;
    protected Double boxedDoubleField;
    protected Float boxedFloatField;
    protected Integer boxedIntField;
    protected Long boxedLongField;
    protected Short boxedShortField;
    protected String boxedStringField;
    protected int[] intArrayField;
    protected short[] shortArrayField;
    protected long[] longArrayField;
    protected double[] doubleArrayField;
    protected float[] floatArrayField;
    protected boolean[] booleanArrayField;
    protected char[] charArrayField;
    protected byte[] byteArrayField;
    protected Integer[] boxedIntArrayField;
    protected Short[] boxedShortArrayField;
    protected Long[] boxedLongArrayField;
    protected Double[] boxedDoubleArrayField;
    protected Float[] boxedFloatArrayField;
    protected Boolean[] boxedBooleanArrayField;
    protected Character[] boxedCharArrayField;
    protected Byte[] boxedByteArrayField;
    protected String[] boxedStringArrayField;

    public int getIntField() {
        return intField;
    }

    public void setIntField(int intField) {
        this.intField = intField;
    }

    public short getShortField() {
        return shortField;
    }

    public void setShortField(short shortField) {
        this.shortField = shortField;
    }

    public long getLongField() {
        return longField;
    }

    public void setLongField(long longField) {
        this.longField = longField;
    }

    public double getDoubleField() {
        return doubleField;
    }

    public void setDoubleField(double doubleField) {
        this.doubleField = doubleField;
    }

    public float getFloatField() {
        return floatField;
    }

    public void setFloatField(float floatField) {
        this.floatField = floatField;
    }

    public boolean isBooleanField() {
        return booleanField;
    }

    public void setBooleanField(boolean booleanField) {
        this.booleanField = booleanField;
    }

    public char getCharField() {
        return charField;
    }

    public void setCharField(char charField) {
        this.charField = charField;
    }

    public byte getByteField() {
        return byteField;
    }

    public void setByteField(byte byteField) {
        this.byteField = byteField;
    }

    public Integer getBoxedIntField() {
        return boxedIntField;
    }

    public void setBoxedIntField(Integer boxedIntField) {
        this.boxedIntField = boxedIntField;
    }

    public Short getBoxedShortField() {
        return boxedShortField;
    }

    public void setBoxedShortField(Short boxedShortField) {
        this.boxedShortField = boxedShortField;
    }

    public Long getBoxedLongField() {
        return boxedLongField;
    }

    public void setBoxedLongField(Long boxedLongField) {
        this.boxedLongField = boxedLongField;
    }

    public Double getBoxedDoubleField() {
        return boxedDoubleField;
    }

    public void setBoxedDoubleField(Double boxedDoubleField) {
        this.boxedDoubleField = boxedDoubleField;
    }

    public Float getBoxedFloatField() {
        return boxedFloatField;
    }

    public void setBoxedFloatField(Float boxedFloatField) {
        this.boxedFloatField = boxedFloatField;
    }

    public Boolean getBoxedBooleanField() {
        return boxedBooleanField;
    }

    public void setBoxedBooleanField(Boolean boxedBooleanField) {
        this.boxedBooleanField = boxedBooleanField;
    }

    public Character getBoxedCharField() {
        return boxedCharField;
    }

    public void setBoxedCharField(Character boxedCharField) {
        this.boxedCharField = boxedCharField;
    }

    public Byte getBoxedByteField() {
        return boxedByteField;
    }

    public void setBoxedByteField(Byte boxedByteField) {
        this.boxedByteField = boxedByteField;
    }

    public int[] getIntArrayField() {
        return intArrayField;
    }

    public void setIntArrayField(int[] intArrayField) {
        this.intArrayField = intArrayField;
    }

    public short[] getShortArrayField() {
        return shortArrayField;
    }

    public void setShortArrayField(short[] shortArrayField) {
        this.shortArrayField = shortArrayField;
    }

    public long[] getLongArrayField() {
        return longArrayField;
    }

    public void setLongArrayField(long[] longArrayField) {
        this.longArrayField = longArrayField;
    }

    public double[] getDoubleArrayField() {
        return doubleArrayField;
    }

    public void setDoubleArrayField(double[] doubleArrayField) {
        this.doubleArrayField = doubleArrayField;
    }

    public float[] getFloatArrayField() {
        return floatArrayField;
    }

    public void setFloatArrayField(float[] floatArrayField) {
        this.floatArrayField = floatArrayField;
    }

    public boolean[] getBooleanArrayField() {
        return booleanArrayField;
    }

    public void setBooleanArrayField(boolean[] booleanArrayField) {
        this.booleanArrayField = booleanArrayField;
    }

    public char[] getCharArrayField() {
        return charArrayField;
    }

    public void setCharArrayField(char[] charArrayField) {
        this.charArrayField = charArrayField;
    }

    public byte[] getByteArrayField() {
        return byteArrayField;
    }

    public void setByteArrayField(byte[] byteArrayField) {
        this.byteArrayField = byteArrayField;
    }

    public Integer[] getBoxedIntArrayField() {
        return boxedIntArrayField;
    }

    public void setBoxedIntArrayField(Integer[] boxedIntArrayField) {
        this.boxedIntArrayField = boxedIntArrayField;
    }

    public Short[] getBoxedShortArrayField() {
        return boxedShortArrayField;
    }

    public void setBoxedShortArrayField(Short[] boxedShortArrayField) {
        this.boxedShortArrayField = boxedShortArrayField;
    }

    public Long[] getBoxedLongArrayField() {
        return boxedLongArrayField;
    }

    public void setBoxedLongArrayField(Long[] boxedLongArrayField) {
        this.boxedLongArrayField = boxedLongArrayField;
    }

    public Double[] getBoxedDoubleArrayField() {
        return boxedDoubleArrayField;
    }

    public void setBoxedDoubleArrayField(Double[] boxedDoubleArrayField) {
        this.boxedDoubleArrayField = boxedDoubleArrayField;
    }

    public Float[] getBoxedFloatArrayField() {
        return boxedFloatArrayField;
    }

    public void setBoxedFloatArrayField(Float[] boxedFloatArrayField) {
        this.boxedFloatArrayField = boxedFloatArrayField;
    }

    public Boolean[] getBoxedBooleanArrayField() {
        return boxedBooleanArrayField;
    }

    public void setBoxedBooleanArrayField(Boolean[] boxedBooleanArrayField) {
        this.boxedBooleanArrayField = boxedBooleanArrayField;
    }

    public Character[] getBoxedCharArrayField() {
        return boxedCharArrayField;
    }

    public void setBoxedCharArrayField(Character[] boxedCharArrayField) {
        this.boxedCharArrayField = boxedCharArrayField;
    }

    public Byte[] getBoxedByteArrayField() {
        return boxedByteArrayField;
    }

    public void setBoxedByteArrayField(Byte[] boxedByteArrayField) {
        this.boxedByteArrayField = boxedByteArrayField;
    }

    public String getBoxedStringField() {
        return boxedStringField;
    }

    public void setBoxedStringField(String boxedStringField) {
        this.boxedStringField = boxedStringField;
    }

    public String[] getBoxedStringArrayField() {
        return boxedStringArrayField;
    }

    public void setBoxedStringArrayField(String[] boxedStringArrayField) {
        this.boxedStringArrayField = boxedStringArrayField;
    }

    @Override
    public String toString() {
        return "BaseFlatPrimitiveClass [intField=" + intField + ", shortField=" + shortField + ", longField="
                + longField + ", doubleField=" + doubleField + ", floatField=" + floatField + ", booleanField="
                + booleanField + ", charField=" + charField + ", byteField=" + byteField + ", boxedBooleanField="
                + boxedBooleanField + ", boxedByteField=" + boxedByteField + ", boxedCharField=" + boxedCharField
                + ", boxedDoubleField=" + boxedDoubleField + ", boxedFloatField=" + boxedFloatField + ", boxedIntField="
                + boxedIntField + ", boxedLongField=" + boxedLongField + ", boxedShortField=" + boxedShortField
                + ", boxedStringField=" + boxedStringField + ", intArrayField=" + Arrays.toString(intArrayField)
                + ", shortArrayField=" + Arrays.toString(shortArrayField) + ", longArrayField="
                + Arrays.toString(longArrayField) + ", doubleArrayField=" + Arrays.toString(doubleArrayField)
                + ", floatArrayField=" + Arrays.toString(floatArrayField) + ", booleanArrayField="
                + Arrays.toString(booleanArrayField) + ", charArrayField=" + Arrays.toString(charArrayField)
                + ", byteArrayField=" + Arrays.toString(byteArrayField) + ", boxedIntArrayField="
                + Arrays.toString(boxedIntArrayField) + ", boxedShortArrayField="
                + Arrays.toString(boxedShortArrayField) + ", boxedLongArrayField="
                + Arrays.toString(boxedLongArrayField) + ", boxedDoubleArrayField="
                + Arrays.toString(boxedDoubleArrayField) + ", boxedFloatArrayField="
                + Arrays.toString(boxedFloatArrayField) + ", boxedBooleanArrayField="
                + Arrays.toString(boxedBooleanArrayField) + ", boxedCharArrayField="
                + Arrays.toString(boxedCharArrayField) + ", boxedByteArrayField=" + Arrays.toString(boxedByteArrayField)
                + ", boxedStringArrayField=" + Arrays.toString(boxedStringArrayField) + "]";
    }

}
