/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class AtlasMap3942Test {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMap3942Test.class);

    @Test
    public void testJsonXml() throws Exception {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-3942-jsonxml-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("data/issue/atlasmap-3942-source-json.json");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
        }
        r.close();
        session.setSourceDocument("SetSupplementaryService_nbi-46cd3ae2-346c-40f1-bedc-823d7365d834", (Object)buf.toString());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("SetSupplementaryService_sbi-8cae15cf-480a-4427-b567-d49a1e9196d2");
        Assertions.assertNotNull((Object)output);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("tns", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("ns1", "http://schemas.ericsson.com/cai3g1.2/");
        namespaces.put("ns2", "http://schemas.ericsson.com/ma/CA/Unn/");
        XmlAssert.assertThat((Object)output).withNamespaceContext(namespaces).doesNotHaveXPath("/tns:Envelope/tns:Body/ns1:Set/ns1:MOAttributes/ns2:SetUnnSubscription/ns2:lock");
        XmlAssert.assertThat((Object)output).withNamespaceContext(namespaces).doesNotHaveXPath("/tns:Envelope/tns:Body/ns1:Set/ns1:MOAttributes/ns2:SetUnnSubscription/ns2:hold/ns2:item/ns2:doesnotexist");
        XmlAssert.assertThat((Object)output).withNamespaceContext(namespaces).doesNotHaveXPath("/tns:Envelope/tns:Body/ns1:Set/ns1:MOAttributes/ns2:SetUnnSubscription/ns2:doesnotexist2");
    }

    @Test
    public void testXmlJson() throws Exception {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-3942-xmljson-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("data/issue/atlasmap-3942-source-xml.xml");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
        }
        r.close();
        session.setSourceDocument("nb_eda_auc_response_xml_create_xsd_schema-49002548-5abe-4333-9e90-d017b4da6262", (Object)buf.toString());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("nb_eda_auc_response_json_create_schema-37a5b6fe-3c92-4f83-a8b2-66c07e833e8f");
        Assertions.assertNotNull((Object)output);
        JsonNode root = new ObjectMapper().readTree((String)output);
        Assertions.assertFalse((boolean)root.get("SetResponse").get("Status").has("ResultCode"));
        Assertions.assertFalse((boolean)root.get("SetResponse").get("Status").has("Does"));
        Assertions.assertFalse((boolean)root.get("SetResponse").get("Status").has("Does2"));
    }
}

