/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.java.test.TargetContact;
import io.atlasmap.java.test.TargetTestClass;
import java.net.URL;
import java.util.LinkedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DfdlCsvTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-dfdl-csv.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        TargetTestClass javaSource = new TargetTestClass();
        javaSource.setContactList(new LinkedList());
        TargetContact tc = new TargetContact();
        tc.setFirstName("firstName1");
        tc.setLastName("lastName1");
        tc.setPhoneNumber("111-111-1111");
        javaSource.getContactList().add(tc);
        tc = new TargetContact();
        tc.setFirstName("firstName2");
        tc.setLastName("lastName2");
        tc.setPhoneNumber("222-222-2222");
        javaSource.getContactList().add(tc);
        tc = new TargetContact();
        tc.setFirstName("firstName3");
        tc.setLastName("lastName3");
        tc.setPhoneNumber("333-333-3333");
        javaSource.getContactList().add(tc);
        session.setSourceDocument("java-source", (Object)javaSource);
        String csvSource = TestHelper.readStringFromFile("atlas-dfdl-csv-simple.csv");
        session.setSourceDocument("dfdl-csv-source", (Object)csvSource);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object jt = session.getTargetDocument("java-target");
        Assertions.assertEquals(TargetTestClass.class, jt.getClass());
        TargetTestClass javaTarget = (TargetTestClass)TargetTestClass.class.cast(jt);
        Assertions.assertEquals((int)3, (int)javaTarget.getContactList().size());
        Assertions.assertEquals((Object)"l1r1", (Object)((TargetContact)javaTarget.getContactList().get(0)).getFirstName());
        Assertions.assertEquals((Object)"l3r3", (Object)((TargetContact)javaTarget.getContactList().get(2)).getPhoneNumber());
        Object dct = session.getTargetDocument("dfdl-csv-target");
        String dfdlCsvTarget = (String)String.class.cast(dct);
        Assertions.assertEquals((Object)TestHelper.readStringFromFile("data/dfdl-csv-target.csv"), (Object)dfdlCsvTarget);
    }
}

