/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.TargetClass;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class AtlasMap846Test {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMap846Test.class);

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-846-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"[]");
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object outputJson = session.getTargetDocument("target-json");
        Assertions.assertNotNull((Object)outputJson, (String)"target-json document was null");
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree("{\"body\":[],\"three\":[]}");
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target-json >>> {}", (Object)actual.toString());
        Assertions.assertTrue((boolean)expected.equals((Object)actual), (String)actual.toString());
        Object outputXml = session.getTargetDocument("target-xml");
        Assertions.assertNotNull((Object)outputXml, (String)"target-xml document was null");
        XmlAssert.assertThat((Object)outputXml).nodesByXPath("/root").exist();
        LOG.info(">>> output:target-xml >>> {}", (Object)outputXml.toString());
        Object outputJava = session.getTargetDocument("target-java");
        Assertions.assertNotNull((Object)outputJava, (String)"target-java document was null");
        Assertions.assertEquals(TargetClass.class, outputJava.getClass());
        TargetClass targetClass = (TargetClass)outputJava;
        Assertions.assertEquals((int)0, (int)targetClass.getTargetList().size());
        Assertions.assertEquals((int)0, (int)targetClass.getTargetStringList().size());
    }

    @Test
    public void testHappyPath() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-846-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"[{\"first_name\":\"Tom\",\"last_name\":\"Silva\",\"three\":\"three\"}]");
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object outputJson = session.getTargetDocument("target-json");
        Assertions.assertNotNull((Object)outputJson, (String)"target-json document was null");
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree("{\"body\":[{\"A\":\"Tom\",\"B\":\"Silva\"}],\"three\":[\"three\"]}");
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target-json >>> {}", (Object)actual.toString());
        Assertions.assertTrue((boolean)expected.equals((Object)actual), (String)actual.toString());
        Object outputXml = session.getTargetDocument("target-xml");
        Assertions.assertNotNull((Object)outputXml, (String)"target-xml document was null");
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/body/A").isEqualTo((Object)"Tom");
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/body/B").isEqualTo((Object)"Silva");
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/three").isEqualTo((Object)"three");
        LOG.info(">>> output:target-xml >>> {}", (Object)outputXml.toString());
        Object outputJava = session.getTargetDocument("target-java");
        Assertions.assertNotNull((Object)outputJava, (String)"target-java document was null");
        Assertions.assertEquals(TargetClass.class, outputJava.getClass());
        TargetClass targetClass = (TargetClass)outputJava;
        Assertions.assertEquals((int)1, (int)targetClass.getTargetList().size());
        Assertions.assertEquals((int)1, (int)targetClass.getTargetStringList().size());
    }
}

