/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class AtlasMap3549Test {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMap3549Test.class);

    @Test
    public void test1() throws Exception {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-3549-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("data/issue/atlasmap-3549-source1.json");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
        }
        r.close();
        session.setSourceDocument("ocsMapping-b9108c7e-6bce-4b93-99cc-fe46c5c45f5a", (Object)buf.toString());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("GBADRequest-508cf937-27b1-4e12-b2a6-2c02f2da2032");
        Assertions.assertNotNull((Object)output);
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/methodName").isEqualTo((Object)"GetBalanceAndDate");
        XmlAssert.assertThat((Object)output).valueByXPath("count(/methodCall/params/param/value/struct/member)").isEqualTo(1);
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/name").isEqualTo((Object)"booleanFieldName");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/string").isEqualTo((Object)"abc");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/boolean").isEqualTo((Object)"true");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/dateTime.iso8601").isEqualTo((Object)"20070925T21:36:59+0530");
    }

    @Test
    public void test2() throws Exception {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-3549-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("data/issue/atlasmap-3549-source2.json");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
        }
        r.close();
        session.setSourceDocument("ocsMapping-b9108c7e-6bce-4b93-99cc-fe46c5c45f5a", (Object)buf.toString());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("GBADRequest-508cf937-27b1-4e12-b2a6-2c02f2da2032");
        Assertions.assertNotNull((Object)output);
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/methodName").isEqualTo((Object)"GetBalanceAndDate");
        XmlAssert.assertThat((Object)output).valueByXPath("count(/methodCall/params/param/value/struct/member)").isEqualTo(2);
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/name").isEqualTo((Object)"abc1");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/string").isEqualTo((Object)"xmyya");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/boolean").isEqualTo((Object)"");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[1]/value/dateTime.iso8601").isEqualTo((Object)"");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[2]/name").isEqualTo((Object)"booleanParamFieldName");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[2]/value/string").isEqualTo((Object)"");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[2]/value/boolean").isEqualTo((Object)"true");
        XmlAssert.assertThat((Object)output).valueByXPath("/methodCall/params/param/value/struct/member[2]/value/dateTime.iso8601").isEqualTo((Object)"");
    }
}

