/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.BaseClass;
import io.atlasmap.itests.core.SourceClass;
import io.atlasmap.itests.core.TargetClass;
import io.atlasmap.itests.core.TestHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionTest {
    @Test
    public void testFilterSelectJava() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-java.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        ArrayList<BaseClass.SomeNestedClass> sourceList = new ArrayList<BaseClass.SomeNestedClass>();
        for (int i = 0; i < 5; ++i) {
            BaseClass.SomeNestedClass s = new BaseClass.SomeNestedClass();
            s.setSomeField("v" + i);
            sourceList.add(s);
        }
        SourceClass source = new SourceClass();
        source.setSomeArray(sourceList.toArray(new BaseClass.SomeNestedClass[0]));
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assertions.assertEquals((int)4, (int)array.length);
        Assertions.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assertions.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testFilterSelectJson() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-json.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-expression-filter-select.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assertions.assertEquals((int)4, (int)array.length);
        Assertions.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assertions.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testFilterSelectXml() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-xml.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceXml = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/xml-source-expression-filter-select.xml").toURI())));
        session.setSourceDocument("xml-source", (Object)sourceXml);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assertions.assertEquals((int)4, (int)array.length);
        Assertions.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assertions.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testAction() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-action.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeIntArray(new int[]{1, 2, 3, 4, 5});
        source.setSomeStringArray(new String[]{"one", "two", "three", "four"});
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((double)3.0, (double)target.getSomeDouble(), (double)0.01);
        Assertions.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE", "FOUR"}, (Object[])target.getSomeStringArray());
    }

    @Test
    public void testCompare() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-compare.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeBigDecimal(new BigDecimal("1"));
        source.setSomeBigInteger(new BigInteger("2"));
        source.setSomeLong(3L);
        source.setSomeDouble(4.0);
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"3", (Object)target.getSomeField());
        Assertions.assertEquals((Object)"3", (Object)target.getSomeString());
        Assertions.assertEquals((int)10, (int)target.getSomeInt());
    }

    @Test
    public void testPlus() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-oper.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeField("first");
        source.setSomeString("second");
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"firstsecond", (Object)target.getSomeField());
    }
}

