/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.ENTESB16270Test;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ENTESB17399Test {
    private static final Logger LOG = LoggerFactory.getLogger(ENTESB16270Test.class);

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/entesb-17399-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        URL in = Thread.currentThread().getContextClassLoader().getResource("data/issue/entesb-17399-source1.json");
        String source = new String(Files.readAllBytes(Paths.get(in.toURI())));
        session.setSourceDocument("-MkqPBsPav60JEAxwZ2K", (Object)source);
        in = Thread.currentThread().getContextClassLoader().getResource("data/issue/entesb-17399-source2.json");
        source = new String(Files.readAllBytes(Paths.get(in.toURI())));
        session.setSourceDocument("-MkqPH7Gav60JEAxwZ2K", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object target = session.getTargetDocument("-MkqPFJhav60JEAxwZ2K");
        Assertions.assertNotNull((Object)target);
        LOG.info(target.toString());
        JsonNode root = new ObjectMapper().readTree(target.toString());
        JsonNode column2 = root.get("column2");
        Assertions.assertEquals((Object)"task1", (Object)column2.asText());
        JsonNode task = root.get("task");
        Assertions.assertEquals((Object)"Red Hat", (Object)task.asText());
    }
}

