/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonBigIntegerTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-json-biginteger.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-biginteger.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        String output = (String)session.getTargetDocument("json-target");
        JsonNode root = new ObjectMapper().readTree(output);
        JsonNode field = root.get("field");
        Assertions.assertEquals((Object)true, (Object)field.isBigInteger());
        Assertions.assertEquals((Object)"1234567890123456789012345678901234567890", (Object)field.asText());
        JsonNode auto = root.get("auto");
        Assertions.assertEquals((Object)true, (Object)auto.isBigInteger());
        Assertions.assertEquals((Object)"12345678901234567890123456789012345678901", (Object)auto.asText());
    }
}

