/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ENTESB16270Test {
    private static final Logger LOG = LoggerFactory.getLogger(ENTESB16270Test.class);

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/entesb-16270-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        URL in = Thread.currentThread().getContextClassLoader().getResource("data/issue/entesb-16270-source.json");
        String source = new String(Files.readAllBytes(Paths.get(in.toURI())));
        session.setSourceDocument("-MYipd8jDixHjPa9gjIU", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object target = session.getTargetDocument("-MYipkI9DixHjPa9gjIU");
        Assertions.assertNotNull((Object)target);
        LOG.info(target.toString());
        JsonNode root = new ObjectMapper().readTree(target.toString());
        ArrayNode arr = (ArrayNode)root.get("arr");
        Assertions.assertEquals((int)5, (int)arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            JsonNode entry = arr.get(i);
            Assertions.assertEquals((Object)("t" + i), (Object)entry.get("name").asText());
        }
    }
}

