/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMap1408Test {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMap1408Test.class);

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-1408-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-1408-source.xml");
        session.setSourceDocument("swagger-request", (Object)new String(Files.readAllBytes(Paths.get(url.toURI()))));
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object outputJson = session.getTargetDocument("request");
        Assertions.assertNotNull((Object)outputJson, (String)"target json document was null");
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree(Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-1408-target.json"));
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target json >>> {}", (Object)actual.toString());
        Assertions.assertTrue((boolean)expected.equals((Object)actual), (String)actual.toString());
    }
}

