/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.TargetClass;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConstantPropertyTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/constant-property-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        TargetClass output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assertions.assertEquals((Object)"testValue", (Object)output.getTargetName());
        Assertions.assertNotEquals((Object)"testPath", (Object)output.getTargetFirstName());
        Assertions.assertEquals((int)777, (int)output.getTargetInteger());
        System.setProperty("testProp", "testProp-sysProp");
        System.setProperty("PATH", "PATH-sysProp");
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assertions.assertEquals((Object)"testProp-sysProp", (Object)output.getTargetName());
        Assertions.assertEquals((Object)"PATH-sysProp", (Object)output.getTargetFirstName());
        Assertions.assertEquals((int)777, (int)output.getTargetInteger());
        session.getSourceProperties().put("testProp", "testProp-runtimeProp");
        session.getSourceProperties().put("PATH", "PATH-runtimeProp");
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assertions.assertEquals((Object)"testProp-runtimeProp", (Object)output.getTargetName());
        Assertions.assertEquals((Object)"PATH-runtimeProp", (Object)output.getTargetFirstName());
        Assertions.assertEquals((int)777, (int)output.getTargetInteger());
    }
}

