/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class AtlasMap3829Test {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMap3829Test.class);

    @Test
    public void test() throws Exception {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-3829.adm");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("data/issue/atlasmap-3829-source.json");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
        }
        r.close();
        session.setSourceDocument("CreateEquipment_nbi-62470cd0-20b6-4e32-8722-0ec55f738387", (Object)buf.toString());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("testxsd-5d290ff3-bfdd-4f92-80fe-f5fbe2512d06");
        Assertions.assertNotNull((Object)output);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("tns", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("ns1", "http://schemas.ericsson.com/cai3g1.2/");
        namespaces.put("ns2", "http://schemas.ericsson.com/ma/EIR/");
        XmlAssert.assertThat((Object)output).withNamespaceContext(namespaces).valueByXPath("/tns:Envelope/tns:Body/ns1:Create/ns1:MOAttributes/ns2:CreateEquipment/@imei").isEqualTo((Object)"55555987654321");
        XmlAssert.assertThat((Object)output).withNamespaceContext(namespaces).valueByXPath("/tns:Envelope/tns:Body/ns1:Create/ns1:MOAttributes/ns2:CreateEquipment/@svn").isEqualTo((Object)"16");
    }
}

