/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.builder.DefaultAtlasMappingBuilder;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xmlunit.assertj.XmlAssert;

public class MappingBuilderTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-builder.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-builder.json").toURI())));
        session.setSourceDocument("SourceJson", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        String targetXml = (String)session.getTargetDocument("TargetXml");
        Assertions.assertNotNull((Object)"target XML is null", (String)targetXml);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("tns", "http://atlasmap.io/itests/builder");
        XmlAssert.assertThat((Object)targetXml).withNamespaceContext(namespaces).valueByXPath("//foo/bar/test").isEqualTo((Object)"4123562");
    }

    public static class JsonXmlBuilder
    extends DefaultAtlasMappingBuilder {
        public void processMapping() throws Exception {
            this.read("SourceJson", "/sourceOrderList/orderBatchNumber").write("TargetXml", "/foo/bar/test");
        }
    }
}

