/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Mapping;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedCollectionJsonTest {
    private static final Logger LOG = LoggerFactory.getLogger(NestedCollectionJsonTest.class);
    private ObjectMapper mapper;

    @BeforeEach
    public void before() {
        this.mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Test
    public void testAsymmetricSingleTarget() throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("mappings/atlasmapping-nested-collection-asymmetric.json");
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        mapping.getMappings().getMapping().removeIf(m -> !"3-1".equals(((Mapping)m).getId()));
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        Assertions.assertEquals(String.class, output.getClass());
        JsonNode outputJson = this.mapper.readTree((String)output);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assertions.assertEquals((int)10, (int)firstArray.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-0-0", (Object)firstArray.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(0).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-0-1", (Object)firstArray.get(1).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(1).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-0", (Object)firstArray.get(2).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(2).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-1", (Object)firstArray.get(3).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(3).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-2", (Object)firstArray.get(4).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(4).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-0", (Object)firstArray.get(5).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(5).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-1", (Object)firstArray.get(6).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(6).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-2", (Object)firstArray.get(7).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(7).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-1-0", (Object)firstArray.get(8).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(8).get("secondArray"), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-1-1", (Object)firstArray.get(9).get("value").asText(), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(9).get("secondArray"), (String)prettyPrinted);
    }

    @Test
    public void testSamePaths1stLevelCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = this.assert1stLevelCollection(outputJson, prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(0).get("secondArray"), (String)prettyPrinted);
        Assertions.assertNull((Object)firstArray.get(1).get("secondArray"), (String)prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2nAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAndPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-3"), false);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode thirdArray = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray").get(0).get("thirdArray");
        Assertions.assertEquals((int)2, (int)thirdArray.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"firstArrayValue0", (Object)thirdArray.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"firstArrayValue1", (Object)thirdArray.get(1).get("value").asText(), (String)prettyPrinted);
    }

    @Test
    public void test3To2LevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-2"), false);
        Assertions.assertEquals((int)2, (int)outputJson.get("firstArray").size());
        ArrayNode secondArray0 = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray");
        this.assertHasValues(secondArray0, "thirdArrayValue0-0-0", "thirdArrayValue0-0-1", "thirdArrayValue0-1-0", "thirdArrayValue0-1-1", "thirdArrayValue0-1-2");
        ArrayNode secondArray1 = (ArrayNode)outputJson.get("firstArray").get(1).get("secondArray");
        this.assertHasValues(secondArray1, "thirdArrayValue1-0-0", "thirdArrayValue1-0-1", "thirdArrayValue1-0-2", "thirdArrayValue1-1-0", "thirdArrayValue1-1-1");
    }

    @Test
    public void test4To2LevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("4-2"), false);
        Assertions.assertEquals((int)2, (int)outputJson.get("firstArray").size());
        ArrayNode secondArray0 = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray");
        this.assertHasValues(secondArray0, "fourthArrayValue0-0-0-0", "fourthArrayValue0-0-0-1");
        ArrayNode secondArray1 = (ArrayNode)outputJson.get("firstArray").get(1).get("secondArray");
        this.assertHasValues(secondArray1, "fourthArrayValue1-1-0-0", "fourthArrayValue1-1-0-1");
    }

    private void assertHasValues(ArrayNode actual, String ... expectedValues) {
        ArrayList actualValues = new ArrayList();
        ArrayList<String> notFound = new ArrayList<String>();
        actual.elements().forEachRemaining(n -> actualValues.add(n.get("value").asText()));
        for (String expected : expectedValues) {
            if (actualValues.contains(expected)) continue;
            notFound.add(expected);
        }
        if (!notFound.isEmpty()) {
            Assertions.fail((String)(((Object)notFound).toString() + " were not found"));
        }
    }

    private JsonNode processJsonNestedCollection(List<String> mappingsToProcess, boolean assertNoWarnings) throws AtlasException, IOException, URISyntaxException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("mappings/atlasmapping-nested-collection-json.json");
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        mapping.getMappings().getMapping().removeIf(m -> !mappingsToProcess.contains(((Mapping)m).getId()));
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        if (assertNoWarnings) {
            Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        }
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        return this.mapper.readTree((String)output);
    }

    private ArrayNode assert1stLevelCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assertions.assertEquals((int)2, (int)firstArray.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"firstArrayValue0", (Object)firstArray.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"firstArrayValue1", (Object)firstArray.get(1).get("value").asText(), (String)prettyPrinted);
        return firstArray;
    }

    private void assert2ndLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assertions.assertEquals((int)2, (int)firstArray.size(), (String)prettyPrinted);
        Assertions.assertEquals((int)2, (int)firstArray.get(0).get("secondArray").size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"secondArrayValue0-0", (Object)firstArray.get(0).get("secondArray").get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"secondArrayValue0-1", (Object)firstArray.get(0).get("secondArray").get(1).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((int)2, (int)firstArray.get(1).get("secondArray").size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"secondArrayValue1-0", (Object)firstArray.get(1).get("secondArray").get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"secondArrayValue1-1", (Object)firstArray.get(1).get("secondArray").get(1).get("value").asText(), (String)prettyPrinted);
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, null);
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray" + suffix);
        Assertions.assertEquals((int)2, (int)firstArray.size(), (String)prettyPrinted);
        JsonNode secondArray0 = firstArray.get(0).get("secondArray" + suffix);
        Assertions.assertEquals((int)2, (int)secondArray0.size(), (String)prettyPrinted);
        JsonNode thirdArray00 = secondArray0.get(0).get("thirdArray" + suffix);
        Assertions.assertEquals((int)2, (int)thirdArray00.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-0-0", (Object)thirdArray00.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-0-1", (Object)thirdArray00.get(1).get("value").asText(), (String)prettyPrinted);
        JsonNode thirdArray01 = secondArray0.get(1).get("thirdArray" + suffix);
        Assertions.assertEquals((int)3, (int)thirdArray01.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-0", (Object)thirdArray01.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-1", (Object)thirdArray01.get(1).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue0-1-2", (Object)thirdArray01.get(2).get("value").asText(), (String)prettyPrinted);
        JsonNode secondArray1 = firstArray.get(1).get("secondArray" + suffix);
        Assertions.assertEquals((int)2, (int)secondArray1.size(), (String)prettyPrinted);
        JsonNode thirdArray10 = secondArray1.get(0).get("thirdArray" + suffix);
        Assertions.assertEquals((int)3, (int)thirdArray10.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-0", (Object)thirdArray10.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-1", (Object)thirdArray10.get(1).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-0-2", (Object)thirdArray10.get(2).get("value").asText(), (String)prettyPrinted);
        JsonNode thirdArray11 = secondArray1.get(1).get("thirdArray" + suffix);
        Assertions.assertEquals((int)2, (int)thirdArray11.size(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-1-0", (Object)thirdArray11.get(0).get("value").asText(), (String)prettyPrinted);
        Assertions.assertEquals((Object)"thirdArrayValue1-1-1", (Object)thirdArray11.get(1).get("value").asText(), (String)prettyPrinted);
    }

    @Test
    public void testAsymmetricFull() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)((Audit)session.getAudits().getAudit().get(0)).getMessage().contains("/firstArray<>/secondArray<>/value"), (String)TestHelper.printAudit(session));
        Assertions.assertEquals((Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)((Audit)session.getAudits().getAudit().get(1)).getMessage().contains("/firstArray<>/secondArray<>/value"), (String)TestHelper.printAudit(session));
        Assertions.assertEquals((Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(1)).getStatus(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)((Audit)session.getAudits().getAudit().get(2)).getMessage().contains("/firstArray<>/value"), (String)TestHelper.printAudit(session));
        Assertions.assertEquals((Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(2)).getStatus(), (String)TestHelper.printAudit(session));
    }
}

