/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CombineSeparateChangeDelimiterTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/combine-separate-change-delimiter-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceFirstName("Manjiro").setSourceLastName("Nakahama").setSourceName("Manjiro,Nakahama");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"Manjiro", (Object)target.getTargetFirstName());
        Assertions.assertEquals((Object)"Nakahama", (Object)target.getTargetLastName());
        Assertions.assertEquals((Object)"Manjiro,Nakahama", (Object)target.getTargetName());
    }
}

