/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.BaseClass;
import io.atlasmap.itests.core.SourceClass;
import io.atlasmap.itests.core.TargetClass;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Mapping;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NestedCollectionJavaTest {
    @Test
    public void testSamePaths1stLevelCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1"));
        this.assert1stLevelCollection(target);
    }

    @Test
    public void testSamePaths1stAnd2ndLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "2-2"));
        this.assert1stLevelCollection(target);
        this.assert2ndLevelCollection(target);
    }

    @Test
    public void testSamePaths2ndLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "2-2"));
        this.assert2ndLevelCollection(target);
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "2-2", "3-3"));
        this.assert1stLevelCollection(target);
        this.assert2ndLevelCollection(target);
        this.assert3rdLevelCollection(target);
    }

    @Test
    public void testSamePaths2ndAnd3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("2-2", "3-3"));
        this.assert2ndLevelCollection(target);
        this.assert3rdLevelCollection(target);
    }

    @Test
    public void testSamePaths1stAnd3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "3-3"));
        this.assert1stLevelCollection(target);
        this.assert3rdLevelCollection(target);
    }

    @Test
    public void testSamePaths3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("3-3"));
        this.assert3rdLevelCollection(target);
    }

    @Test
    public void testRenamedPaths3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("3-3renamed"));
        this.assert3rdLevelRenamedCollection(target);
    }

    @Test
    public void testSamePaths1stAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "3-3renamed"));
        this.assert1stLevelCollection(target);
        this.assert3rdLevelRenamedCollection(target);
    }

    @Test
    public void testSamePaths1stAnd2nAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "2-2", "3-3renamed"));
        this.assert1stLevelCollection(target);
        this.assert2ndLevelCollection(target);
        this.assert3rdLevelRenamedCollection(target);
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("1-1", "2-2", "3-3", "3-3renamed"));
        this.assert1stLevelCollection(target);
        this.assert2ndLevelCollection(target);
        this.assert3rdLevelCollection(target);
        this.assert3rdLevelRenamedCollection(target);
    }

    @Test
    public void testAsymmetricPaths1stAnd2ndAnd3rdLevelNestedCollectionToSingleCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("3-1"));
        Assertions.assertEquals((int)5, (int)target.getSomeArray().length);
        Assertions.assertEquals((Object)"array000", (Object)target.getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array001", (Object)target.getSomeArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array002", (Object)target.getSomeArray()[2].getSomeField());
        Assertions.assertEquals((Object)"array100", (Object)target.getSomeArray()[3].getSomeField());
        Assertions.assertEquals((Object)"array101", (Object)target.getSomeArray()[4].getSomeField());
        Assertions.assertNull((Object)target.getSomeField());
        Assertions.assertNull((Object)target.getSomeArray()[0].getSomeArray());
        Assertions.assertNull((Object)target.getSomeArray()[1].getSomeArray());
        Assertions.assertNull((Object)target.getSomeArray()[2].getSomeArray());
        Assertions.assertNull((Object)target.getSomeArray()[3].getSomeArray());
        Assertions.assertNull((Object)target.getSomeArray()[4].getSomeArray());
    }

    @Test
    public void testAsymmetricPaths2ndLevelNestedCollectionTo4LevelsNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("2-4"));
        Assertions.assertEquals((int)1, (int)target.getSomeArray().length);
        Assertions.assertEquals((int)1, (int)target.getSomeArray()[0].getSomeArray().length);
        BaseClass.SomeNestedClass[] nestedArray = target.getSomeArray()[0].getSomeArray()[0].getSomeArray();
        TargetClass nestedTarget = new TargetClass();
        nestedTarget.setSomeArray(nestedArray);
        this.assert2ndLevelCollection(nestedTarget);
    }

    @Test
    public void test3To2LevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("3-2"));
        Assertions.assertEquals((int)2, (int)target.getSomeArray().length);
        Assertions.assertEquals((int)3, (int)target.getSomeArray()[0].getSomeArray().length);
        Assertions.assertEquals((Object)"array000", (Object)target.getSomeArray()[0].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array001", (Object)target.getSomeArray()[0].getSomeArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array002", (Object)target.getSomeArray()[0].getSomeArray()[2].getSomeField());
        Assertions.assertEquals((int)2, (int)target.getSomeArray()[1].getSomeArray().length);
        Assertions.assertEquals((Object)"array100", (Object)target.getSomeArray()[1].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array101", (Object)target.getSomeArray()[1].getSomeArray()[1].getSomeField());
    }

    @Test
    public void test4To2LevelNestedCollection() throws Exception {
        TargetClass target = this.processNestedJavaCollection(Arrays.asList("4-2"));
        Assertions.assertEquals((int)2, (int)target.getSomeArray().length);
        Assertions.assertNull((Object)target.getSomeArray()[0]);
        Assertions.assertEquals((int)3, (int)target.getSomeArray()[1].getSomeArray().length);
        Assertions.assertEquals((Object)"array1000", (Object)target.getSomeArray()[1].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array1001", (Object)target.getSomeArray()[1].getSomeArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array1010", (Object)target.getSomeArray()[1].getSomeArray()[2].getSomeField());
    }

    private void assert1stLevelCollection(TargetClass target) {
        Assertions.assertEquals((int)3, (int)target.getSomeArray().length);
        Assertions.assertEquals((Object)"array0", (Object)target.getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array1", (Object)target.getSomeArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array2", (Object)target.getSomeArray()[2].getSomeField());
    }

    private void assert2ndLevelCollection(TargetClass target) {
        Assertions.assertEquals((int)2, (int)target.getSomeArray()[0].getSomeArray().length);
        Assertions.assertEquals((Object)"array00", (Object)target.getSomeArray()[0].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array01", (Object)target.getSomeArray()[0].getSomeArray()[1].getSomeField());
        Assertions.assertEquals((int)1, (int)target.getSomeArray()[1].getSomeArray().length);
        Assertions.assertEquals((Object)"array10", (Object)target.getSomeArray()[1].getSomeArray()[0].getSomeField());
    }

    private void assert3rdLevelCollection(TargetClass target) {
        Assertions.assertEquals((int)3, (int)target.getSomeArray()[0].getSomeArray()[0].getSomeArray().length);
        Assertions.assertEquals((Object)"array000", (Object)target.getSomeArray()[0].getSomeArray()[0].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array001", (Object)target.getSomeArray()[0].getSomeArray()[0].getSomeArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array002", (Object)target.getSomeArray()[0].getSomeArray()[0].getSomeArray()[2].getSomeField());
        Assertions.assertEquals((int)2, (int)target.getSomeArray()[1].getSomeArray()[0].getSomeArray().length);
        Assertions.assertEquals((Object)"array100", (Object)target.getSomeArray()[1].getSomeArray()[0].getSomeArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array101", (Object)target.getSomeArray()[1].getSomeArray()[0].getSomeArray()[1].getSomeField());
    }

    private void assert3rdLevelRenamedCollection(TargetClass target) {
        Assertions.assertEquals((int)3, (int)target.getSomeRenamedArray()[0].getSomeArray()[0].getSomeRenamedArray().length);
        Assertions.assertEquals((Object)"array000", (Object)target.getSomeRenamedArray()[0].getSomeArray()[0].getSomeRenamedArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array001", (Object)target.getSomeRenamedArray()[0].getSomeArray()[0].getSomeRenamedArray()[1].getSomeField());
        Assertions.assertEquals((Object)"array002", (Object)target.getSomeRenamedArray()[0].getSomeArray()[0].getSomeRenamedArray()[2].getSomeField());
        Assertions.assertEquals((int)2, (int)target.getSomeRenamedArray()[1].getSomeArray()[0].getSomeRenamedArray().length);
        Assertions.assertEquals((Object)"array100", (Object)target.getSomeRenamedArray()[1].getSomeArray()[0].getSomeRenamedArray()[0].getSomeField());
        Assertions.assertEquals((Object)"array101", (Object)target.getSomeRenamedArray()[1].getSomeArray()[0].getSomeRenamedArray()[1].getSomeField());
    }

    private TargetClass processNestedJavaCollection(List<String> mappingsToProcess) throws AtlasException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("mappings/atlasmapping-nested-collection-java.json");
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        mapping.getMappings().getMapping().removeIf(m -> !mappingsToProcess.contains(((Mapping)m).getId()));
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass sc = this.newSourceClass();
        session.setSourceDocument("io.atlasmap.itests.core.SourceClass", (Object)sc);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        return (TargetClass)session.getTargetDocument("io.atlasmap.itests.core.TargetClass");
    }

    private SourceClass newSourceClass() {
        SourceClass sc = new SourceClass();
        sc.setSomeField("field");
        BaseClass.SomeNestedClass array0 = new BaseClass.SomeNestedClass("array0");
        BaseClass.SomeNestedClass array1 = new BaseClass.SomeNestedClass("array1");
        BaseClass.SomeNestedClass array2 = new BaseClass.SomeNestedClass("array2");
        BaseClass.SomeNestedClass[] someArray = new BaseClass.SomeNestedClass[]{array0, array1, array2};
        sc.setSomeArray(someArray);
        BaseClass.SomeNestedClass array00 = new BaseClass.SomeNestedClass("array00");
        array00.setSomeArray(new BaseClass.SomeNestedClass[]{new BaseClass.SomeNestedClass("array000"), new BaseClass.SomeNestedClass("array001"), new BaseClass.SomeNestedClass("array002")});
        array0.setSomeArray(new BaseClass.SomeNestedClass[]{array00, new BaseClass.SomeNestedClass("array01")});
        BaseClass.SomeNestedClass array10 = new BaseClass.SomeNestedClass("array10");
        array1.setSomeArray(new BaseClass.SomeNestedClass[]{array10});
        array2.setSomeArray(new BaseClass.SomeNestedClass[0]);
        BaseClass.SomeNestedClass array100 = new BaseClass.SomeNestedClass("array100");
        BaseClass.SomeNestedClass array101 = new BaseClass.SomeNestedClass("array101");
        array10.setSomeArray(new BaseClass.SomeNestedClass[]{array100, array101});
        array100.setSomeArray(new BaseClass.SomeNestedClass[]{new BaseClass.SomeNestedClass("array1000"), new BaseClass.SomeNestedClass("array1001")});
        array101.setSomeArray(new BaseClass.SomeNestedClass[]{new BaseClass.SomeNestedClass("array1010")});
        return sc;
    }
}

