/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import twitter4j.Status;
import twitter4j.User;

public class CamelAtlasmap14Test {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/camel-atlasmap-14-mapping.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        session.setDefaultSourceDocument((Object)this.generateTwitterStatus());
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getDefaultTargetDocument();
        Assertions.assertEquals(String.class, output.getClass());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode outJson = mapper.readTree((String)output);
        Assertions.assertNotNull((Object)outJson.get("TwitterScreenName__c"));
        Assertions.assertEquals((Object)"bobvila1982", (Object)outJson.get("TwitterScreenName__c").asText());
    }

    protected Status generateTwitterStatus() {
        Status status = (Status)Mockito.mock(Status.class);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getName()).thenReturn((Object)"Bob Vila");
        Mockito.when((Object)user.getScreenName()).thenReturn((Object)"bobvila1982");
        Mockito.when((Object)status.getUser()).thenReturn((Object)user);
        Mockito.when((Object)status.getText()).thenReturn((Object)"Let's build a house!");
        return status;
    }
}

