/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.Item;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.java.test.SourceFlatPrimitiveClass;
import io.atlasmap.java.test.TargetFlatPrimitiveClass;
import io.atlasmap.java.test.TargetTestClass;
import io.atlasmap.v2.AuditStatus;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiplicityTransformationTest {
    @Test
    public void testConcatenateSplit() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-split.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceFirstName("Manjiro").setSourceLastName("Nakahama").setSourceName("Manjiro,Nakahama").setSourceString("one,two,three").setSourceStringList(Arrays.asList("one", "two", "three")).setSourceHiphenatedInteger("1-20-300-4000").setSourceStreet("314 Littleton Rd").setSourceWeight("128.965 kg");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-collection.json").toURI())));
        session.setSourceDocument("SourceJson", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertTrue((boolean)session.hasWarns(), (String)"split(STRING) => INTEGER/DOUBLE mapping should get warnings");
        Assertions.assertEquals((long)12L, (long)session.getAudits().getAudit().stream().filter(a -> a.getStatus() == AuditStatus.WARN).count());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"Manjiro", (Object)target.getTargetFirstName());
        Assertions.assertEquals((Object)"Nakahama", (Object)target.getTargetLastName());
        Assertions.assertEquals((Object)"Manjiro,Nakahama", (Object)target.getTargetName());
        Assertions.assertEquals((Object)"One,Nakahama", (Object)target.getTargetFullName());
        Assertions.assertTrue((boolean)session.getAudits().getAudit().stream().anyMatch(audit -> "Using only the first element of the collection since a single value is expected in a multi-field selection.".equals(audit.getMessage())));
        Assertions.assertEquals((Object)"one,two,three", (Object)target.getTargetString());
        Assertions.assertEquals((Integer)314, (Integer)target.getTargetStreetNumber());
        Assertions.assertEquals((Object)"Littleton", (Object)target.getTargetStreetName1());
        Assertions.assertEquals((Object)"Rd", (Object)target.getTargetStreetName2());
        List<String> list = target.getTargetStringList();
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"one", (Object)list.get(0));
        Assertions.assertEquals((Object)"two", (Object)list.get(1));
        Assertions.assertEquals((Object)"three", (Object)list.get(2));
        List<Integer> intList = target.getTargetIntegerList();
        Assertions.assertEquals((int)4, (int)intList.size());
        Assertions.assertEquals((Integer)1, (Integer)intList.get(0));
        Assertions.assertEquals((Integer)20, (Integer)intList.get(1));
        Assertions.assertEquals((Integer)300, (Integer)intList.get(2));
        Assertions.assertEquals((Integer)4000, (Integer)intList.get(3));
        Assertions.assertEquals((Double)128.965, (Double)target.getTargetWeightDouble());
        Assertions.assertEquals((Object)"kg", (Object)target.getTargetWeightUnit());
        Object obj = session.getTargetDocument("TargetJson");
        JsonNode targetJson = new ObjectMapper().readTree((String)obj);
        JsonNode targetJsonString = targetJson.get("targetJsonString");
        Assertions.assertEquals((Object)"2 2 3", (Object)targetJsonString.asText());
    }

    @Test
    public void testConcatenateTypes() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-types.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        TargetTestClass source = new TargetTestClass();
        source.setCreated(new Date());
        TargetFlatPrimitiveClass primitives = new TargetFlatPrimitiveClass();
        primitives.setBoxedStringField("boxedString");
        primitives.setCharField('c');
        primitives.setIntField(1);
        primitives.setFloatField(1.3f);
        primitives.setLongField(2L);
        primitives.setShortField((short)2);
        primitives.setDoubleField(3.1);
        primitives.setBoxedCharField(Character.valueOf('c'));
        primitives.setBoxedIntField(Integer.valueOf(1));
        primitives.setBoxedFloatField(Float.valueOf(1.3f));
        primitives.setBoxedLongField(Long.valueOf(2L));
        primitives.setBoxedShortField(Short.valueOf((short)2));
        primitives.setBoxedDoubleField(Double.valueOf(3.1));
        source.setPrimitives(primitives);
        session.setSourceDocument("io.atlasmap.java.test.TargetTestClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.java.test.TargetTestClass");
        Assertions.assertEquals(TargetTestClass.class, output.getClass());
        TargetTestClass target = (TargetTestClass)TargetTestClass.class.cast(output);
        Assertions.assertEquals((int)14, (int)target.getFullAddress().split(" ").length, (String)("[" + target.getFullAddress() + "]"));
    }

    @Test
    public void testItemAt() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-itemAt.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("one", "two", "three"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"two", (Object)target.getTargetString());
    }

    @Test
    public void testExpression() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-expression.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceString("").setSourceInteger(123).setSourceFirstName(null).setSourceLastName("").setSourceInteger2(-123);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"one-two-three", (Object)target.getTargetString());
        Assertions.assertEquals((int)123, (int)target.getTargetInteger());
        Assertions.assertEquals((Object)"last name is empty", (Object)target.getTargetName());
        Assertions.assertEquals((Object)"true", (Object)target.getTargetFirstName());
        session = context.createSession();
        source = new SourceClass().setSourceString("not empty").setSourceInteger(789).setSourceFirstName(null).setSourceLastName("lastname").setSourceInteger2(790);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"not one-two-three", (Object)target.getTargetString());
        Assertions.assertEquals((int)456, (int)target.getTargetInteger());
        Assertions.assertEquals((Object)"last name is not empty", (Object)target.getTargetName());
        Assertions.assertEquals((Object)"false", (Object)target.getTargetFirstName());
    }

    @Test
    public void testCapitalizeExpressionWithCollection() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-capitalize-expression.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals(Arrays.asList("Bob", "John", "Andrea"), target.getTargetStringList());
    }

    @Test
    public void testConcatenateExpressionWithCollection() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-expression.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        source.setSourceString(",");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"Bob,John,Andrea", (Object)target.getTargetString());
    }

    @Test
    public void testConcatenateExpressionWithTwoCollections() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-expression.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        source.setSourceList(Arrays.asList(new Item("thomas", null), new Item("arnold", null)));
        source.setSourceString(",");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assertions.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assertions.assertEquals((Object)"bob,john,andrea,thomas,arnold", (Object)target.getTargetFirstName());
    }

    @Test
    public void testConcatenateExpressionWithCsv() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-csv.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        session.setSourceDocument("io.atlasmap.itests.core.SourceCsv", (Object)"givenName,familyName\nBob,Smith\nAnthony,Hopkins\nTimothy,Anders");
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Assertions.assertFalse((boolean)session.hasWarns(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.itests.core.TargetCsv");
        Assertions.assertEquals((Object)"allGivenNames,name\r\n\"Bob,Anthony,Timothy\",\"Bob,Anthony,Timothy,Smith,Hopkins,Anders\"\r\n", (Object)output);
    }

    @Test
    public void testAdd() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-add.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        String sourceXml = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/xml-source.xml").toURI())));
        session.setSourceDocument("xml-source", (Object)sourceXml);
        SourceFlatPrimitiveClass sourceJava = new SourceFlatPrimitiveClass();
        sourceJava.setIntArrayField(new int[]{1, 3, 5, 7});
        sourceJava.setBoxedIntListField(Arrays.asList(2, 4, 6, 8));
        session.setSourceDocument("java-source", (Object)sourceJava);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("io.atlasmap.java.test.TargetFlatPrimitiveClass");
        Assertions.assertEquals(TargetFlatPrimitiveClass.class, output.getClass());
        TargetFlatPrimitiveClass target = (TargetFlatPrimitiveClass)TargetFlatPrimitiveClass.class.cast(output);
        Assertions.assertEquals((double)Float.valueOf(16.0f).floatValue(), (double)target.getFloatField(), (double)1.0E-15);
        Assertions.assertEquals((double)16.0, (double)target.getDoubleField(), (double)1.0E-15);
        Assertions.assertEquals((long)16L, (long)target.getLongField());
        Assertions.assertEquals((int)20, (int)target.getIntField());
    }

    @Test
    public void testActionRepeat_1() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-action_repeat.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-repeat.json").toURI())));
        session.setSourceDocument("json-source-repeat", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("json-target");
        Assertions.assertEquals((Object)"[{\"targetField\":\"simpleFieldValue\"}]", (Object)output);
    }

    @Test
    public void testActionRepeatCount3() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-action_repeat.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-repeat_count_3.json").toURI())));
        session.setSourceDocument("json-source-repeat", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("json-target");
        Assertions.assertEquals((Object)"[{\"targetField\":\"simpleFieldValue\"},{\"targetField\":\"simpleFieldValue\"},{\"targetField\":\"simpleFieldValue\"}]", (Object)output);
    }

    @Test
    public void testActionRepeatForNoSourceField() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-action_repeat.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-repeat_no_field.json").toURI())));
        session.setSourceDocument("json-source-repeat", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("json-target");
        Assertions.assertEquals((Object)"[]", (Object)output);
    }

    @Test
    public void testActionRepeatForNestedCollectionField() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-action_repeat_nested_collection.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-repeat_for_nested_collection_field.json").toURI())));
        session.setSourceDocument("json-source-repeat", (Object)sourceJson);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getTargetDocument("json-target");
        Assertions.assertEquals((Object)"[{\"targetField\":\"simpleFieldValue\"},{\"targetField\":\"simpleFieldValue\"},{\"targetField\":\"simpleFieldValue\"}]", (Object)output);
    }
}

