/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.java.test.StringTestClass;
import java.net.URL;
import java.nio.CharBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaStringTypesTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-java-string-types.json");
        DefaultAtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        StringTestClass source = new StringTestClass();
        source.setTestCharBuffer(CharBuffer.wrap("testCharBuffer"));
        source.setTestCharSequence((CharSequence)"testCharSequence");
        source.setTestString("testString");
        source.setTestStringBuffer(new StringBuffer("testStringBuffer"));
        source.setTestStringBuilder(new StringBuilder("testStringBuilder"));
        session.setDefaultSourceDocument((Object)source);
        context.process(session);
        Assertions.assertFalse((boolean)session.hasErrors(), (String)TestHelper.printAudit(session));
        Object output = session.getDefaultTargetDocument();
        Assertions.assertEquals(StringTestClass.class, output.getClass());
        StringTestClass target = (StringTestClass)StringTestClass.class.cast(output);
        Assertions.assertEquals((Object)"testCharBuffer", (Object)target.getTestCharSequence().toString());
        Assertions.assertEquals((Object)"testCharSequence", (Object)target.getTestString());
        Assertions.assertEquals((Object)"testString", (Object)target.getTestStringBuffer().toString());
        Assertions.assertEquals((Object)"testStringBuffer", (Object)target.getTestStringBuilder().toString());
        Assertions.assertEquals((Object)"testStringBuilder", (Object)target.getTestCharBuffer().toString());
    }
}

