/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.assertj.XmlAssert;

public class XMLAttributeTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-xml-attribute-ns.json");
        DefaultAtlasContextFactory factory = DefaultAtlasContextFactory.getInstance();
        AtlasContext context = factory.createContext(url.toURI());
        AtlasSession session = context.createSession();
        String xmlSource = TestHelper.readStringFromFile("data/xml-source-attribute-ns.xml");
        session.setSourceDocument("po-example-schema-f81424a0-8871-4483-abaf-059cc432ea78", (Object)xmlSource);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object target = session.getTargetDocument("po-example-schema-b12bc688-7bf3-4626-97a2-d8c3981ecd3a");
        Assert.assertNotNull((String)"target XML is null", (Object)target);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("ns1", "http://tempuri.org/po.xsd");
        XmlAssert.assertThat((Object)target).withNamespaceContext(namespaces).valueByXPath("//ns1:purchaseOrder/@ns1:orderDate").isEqualTo((Object)"1985-05-02");
        XmlAssert.assertThat((Object)target).withNamespaceContext(namespaces).valueByXPath("//ns1:purchaseOrder/ns1:comment").isEqualTo((Object)"1985-05-02");
    }
}

