/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Mapping;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedCollectionJsonTest {
    private static final Logger LOG = LoggerFactory.getLogger(NestedCollectionJsonTest.class);
    private ObjectMapper mapper;

    @Before
    public void before() {
        this.mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Test
    public void testAsymmetricSingleTarget() throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("mappings/atlasmapping-nested-collection-asymmetric.json");
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        mapping.getMappings().getMapping().removeIf(m -> !"3-1".equals(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        Assert.assertEquals(String.class, output.getClass());
        JsonNode outputJson = this.mapper.readTree((String)output);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)10L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-1", (Object)firstArray.get(1).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-0", (Object)firstArray.get(2).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(2).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-1", (Object)firstArray.get(3).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(3).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-2", (Object)firstArray.get(4).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(4).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-0", (Object)firstArray.get(5).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(5).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-1", (Object)firstArray.get(6).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(6).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-2", (Object)firstArray.get(7).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(7).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-0", (Object)firstArray.get(8).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(8).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-1", (Object)firstArray.get(9).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(9).get("secondArray"));
    }

    @Test
    public void testSamePaths1stLevelCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = this.assert1stLevelCollection(outputJson, prettyPrinted);
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
    }

    @Test
    public void testSamePaths1stAnd2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2nAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3", "3-3renamed"), true);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAndPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-3"), false);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode thirdArray = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray").get(0).get("thirdArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)thirdArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue0", (Object)thirdArray.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue1", (Object)thirdArray.get(1).get("value").asText());
    }

    @Test
    public void test3To2LevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-2"), false);
        Assert.assertThat((Object)outputJson.get("firstArray").size(), (Matcher)CoreMatchers.is((Object)2));
        ArrayNode secondArray0 = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray");
        Assert.assertThat((Object)secondArray0, this.hasValues("thirdArrayValue0-0-0", "thirdArrayValue0-0-1", "thirdArrayValue0-1-0", "thirdArrayValue0-1-1", "thirdArrayValue0-1-2"));
        ArrayNode secondArray1 = (ArrayNode)outputJson.get("firstArray").get(1).get("secondArray");
        Assert.assertThat((Object)secondArray1, this.hasValues("thirdArrayValue1-0-0", "thirdArrayValue1-0-1", "thirdArrayValue1-0-2", "thirdArrayValue1-1-0", "thirdArrayValue1-1-1"));
    }

    @Test
    public void test4To2LevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("4-2"), false);
        Assert.assertThat((Object)outputJson.get("firstArray").size(), (Matcher)CoreMatchers.is((Object)2));
        ArrayNode secondArray0 = (ArrayNode)outputJson.get("firstArray").get(0).get("secondArray");
        Assert.assertThat((Object)secondArray0, this.hasValues("fourthArrayValue0-0-0-0", "fourthArrayValue0-0-0-1"));
        ArrayNode secondArray1 = (ArrayNode)outputJson.get("firstArray").get(1).get("secondArray");
        Assert.assertThat((Object)secondArray1, this.hasValues("fourthArrayValue1-1-0-0", "fourthArrayValue1-1-0-1"));
    }

    private FeatureMatcher<ArrayNode, List<String>> hasValues(String ... values) {
        return new FeatureMatcher<ArrayNode, List<String>>(CoreMatchers.hasItems((Object[])values), "value for", "value for"){

            protected List<String> featureValueOf(ArrayNode actual) {
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < actual.size(); ++i) {
                    values.add(actual.get(i).get("value").asText());
                }
                return values;
            }
        };
    }

    private JsonNode processJsonNestedCollection(List<String> mappingsToProcess, boolean assertNoWarnings) throws AtlasException, IOException, URISyntaxException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("mappings/atlasmapping-nested-collection-json.json");
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        mapping.getMappings().getMapping().removeIf(m -> !mappingsToProcess.contains(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        if (assertNoWarnings) {
            Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        }
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        return this.mapper.readTree((String)output);
    }

    private ArrayNode assert1stLevelCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue1", (Object)firstArray.get(1).get("value").asText());
        return firstArray;
    }

    private void assert2ndLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.get(0).get("secondArray").size());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue0-0", (Object)firstArray.get(0).get("secondArray").get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue0-1", (Object)firstArray.get(0).get("secondArray").get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.get(1).get("secondArray").size());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue1-0", (Object)firstArray.get(1).get("secondArray").get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue1-1", (Object)firstArray.get(1).get("secondArray").get(1).get("value").asText());
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, null);
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        JsonNode secondArray0 = firstArray.get(0).get("secondArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)secondArray0.size());
        JsonNode thirdArray00 = secondArray0.get(0).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)thirdArray00.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-0", (Object)thirdArray00.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-1", (Object)thirdArray00.get(1).get("value").asText());
        JsonNode thirdArray01 = secondArray0.get(1).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)3L, (long)thirdArray01.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-0", (Object)thirdArray01.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-1", (Object)thirdArray01.get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-2", (Object)thirdArray01.get(2).get("value").asText());
        JsonNode secondArray1 = firstArray.get(1).get("secondArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)secondArray1.size());
        JsonNode thirdArray10 = secondArray1.get(0).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)3L, (long)thirdArray10.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-0", (Object)thirdArray10.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-1", (Object)thirdArray10.get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-2", (Object)thirdArray10.get(2).get("value").asText());
        JsonNode thirdArray11 = secondArray1.get(1).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)thirdArray11.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-0", (Object)thirdArray11.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-1", (Object)thirdArray11.get(1).get("value").asText());
    }

    @Test
    public void testAsymmetricFull() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(0)).getMessage().contains("/firstArray<>/secondArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(1)).getMessage().contains("/firstArray<>/secondArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(1)).getStatus());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(2)).getMessage().contains("/firstArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.WARN, (Object)((Audit)session.getAudits().getAudit().get(2)).getStatus());
    }
}

